# Go-to-Market Strategy Builder

Build a complete GTM plan for product launches, market entries, or expansion plays. Covers positioning, channel strategy, pricing, launch timeline, and success metrics.

## When to Use
- Launching a new product or feature
- Entering a new market segment or geography
- Repositioning an existing product
- Planning a pricing change or packaging overhaul
- Preparing a board-level GTM deck

## What You'll Build

### 1. Market Positioning Canvas

**Target Customer Profile:**
| Dimension | Detail |
|-----------|--------|
| Company size | [employees / revenue range] |
| Industry | [primary + adjacent] |
| Buyer persona | [title, pain, budget authority] |
| Current solution | [what they use today] |
| Trigger event | [what makes them look for alternatives] |
| Decision timeline | [typical sales cycle length] |

**Positioning Statement:**
For [target customer] who [problem], [product] is a [category] that [key benefit]. Unlike [alternative], we [differentiator].

**Competitive Landscape:**
| Competitor | Positioning | Price | Weakness We Exploit |
|-----------|-------------|-------|---------------------|
| Direct 1 | | | |
| Direct 2 | | | |
| Indirect 1 | | | |
| Status quo (do nothing) | | $0 | [cost of inaction] |

### 2. Channel Strategy Matrix

Rate each channel 1-5 on Reach, Cost, Speed, and Fit:

| Channel | Reach | Cost | Speed | Fit | Priority |
|---------|-------|------|-------|-----|----------|
| **Outbound sales** | | | | | |
| Cold email sequences | 3 | 2 | 4 | | |
| LinkedIn outreach | 3 | 2 | 3 | | |
| Phone/video prospecting | 2 | 3 | 4 | | |
| **Inbound marketing** | | | | | |
| SEO content | 5 | 2 | 1 | | |
| Paid search (Google) | 4 | 4 | 5 | | |
| Social ads (LinkedIn/Meta) | 4 | 4 | 4 | | |
| **Product-led** | | | | | |
| Free trial / freemium | 5 | 3 | 3 | | |
| Open source / free tools | 5 | 2 | 2 | | |
| Community / word of mouth | 4 | 1 | 1 | | |
| **Partnerships** | | | | | |
| Channel partners / resellers | 4 | 2 | 2 | | |
| Technology integrations | 3 | 3 | 2 | | |
| Co-marketing | 3 | 2 | 3 | | |
| **Events** | | | | | |
| Industry conferences | 3 | 5 | 3 | | |
| Webinars / virtual events | 3 | 2 | 4 | | |
| Local meetups | 2 | 1 | 3 | | |

**Channel Selection Rules:**
- Pick 2-3 channels max for launch (focus beats breadth)
- One channel must produce results within 30 days
- One channel must compound over 6+ months
- Kill any channel not producing pipeline within 60 days

### 3. Pricing & Packaging Framework

**Value Metric:** What does the customer pay for? (per seat, per usage, per outcome, flat fee)

**Pricing Architecture:**
| Tier | Name | Price | Target | Key Features |
|------|------|-------|--------|--------------|
| Free | | $0 | Awareness / PLG | |
| Starter | | $/mo | SMB / individual | |
| Pro | | $/mo | Growth companies | |
| Enterprise | | Custom | 500+ employees | |

**Pricing Validation Checklist:**
- [ ] Tested against willingness-to-pay (Van Westendorp or similar)
- [ ] Compared to 3+ competitors on price/feature ratio
- [ ] Margin covers CAC payback within 12 months
- [ ] Upgrade path is clear and natural
- [ ] No "penny gap" that kills conversion (if using free tier)

**The 1% Rule:** A 1% price increase yields ~12.5% profit increase. Price higher than you think. You can always discount — you can't easily raise.

### 4. Launch Timeline (12 Weeks)

**Weeks 1-2: Foundation**
- [ ] Finalize positioning statement
- [ ] Define ICP with firmographic + behavioral data
- [ ] Set pricing (test with 5-10 prospects before committing)
- [ ] Build landing page with clear CTA
- [ ] Set up analytics (attribution, funnel tracking)

**Weeks 3-4: Content & Assets**
- [ ] Create sales deck (10 slides max)
- [ ] Write 3 case studies or proof points
- [ ] Build email sequences (5-touch cold, 7-touch nurture)
- [ ] Record product demo (2 min max)
- [ ] Prepare FAQ and objection handling doc

**Weeks 5-6: Seed & Test**
- [ ] Soft launch to existing customers / warm network
- [ ] Run 10 discovery calls to validate messaging
- [ ] A/B test landing page headlines
- [ ] Iterate positioning based on feedback
- [ ] Train sales team on pitch and objection handling

**Weeks 7-8: Scale Channels**
- [ ] Launch primary outbound channel
- [ ] Start paid ads (small budget, test creative)
- [ ] Publish first 5 SEO content pieces
- [ ] Announce to email list / social following
- [ ] Activate partnership conversations

**Weeks 9-10: Optimize**
- [ ] Analyze conversion at each funnel stage
- [ ] Kill underperforming channels or messages
- [ ] Double spend on what's working
- [ ] Collect and publish first customer testimonials
- [ ] Refine pricing based on real sales data

**Weeks 11-12: Report & Adjust**
- [ ] Full funnel analysis (impressions → MQL → SQL → closed)
- [ ] CAC calculation by channel
- [ ] Win/loss analysis (why deals close or don't)
- [ ] Adjust Q2 plan based on data
- [ ] Document playbook for repeatable launches

### 5. Success Metrics Dashboard

**Leading Indicators (weekly):**
| Metric | Target | Current | Trend |
|--------|--------|---------|-------|
| Website visitors | | | |
| Demo requests | | | |
| Trial signups | | | |
| MQLs generated | | | |
| Outbound reply rate | | | |

**Lagging Indicators (monthly):**
| Metric | Target | Current | Trend |
|--------|--------|---------|-------|
| SQLs | | | |
| Pipeline created ($) | | | |
| Closed-won deals | | | |
| Revenue ($) | | | |
| CAC | | | |
| CAC payback (months) | | | |
| Win rate (%) | | | |

**Kill Criteria:**
- Channel CAC > 3x target after 60 days → kill
- Win rate < 10% after 20 opportunities → reposition
- Trial-to-paid < 5% after 30 days → fix onboarding
- NPS < 30 at 90 days → fix product before scaling GTM

### 6. Common GTM Mistakes

1. **Launching to everyone.** Pick one beachhead segment. Dominate it. Expand.
2. **Too many channels at once.** Two channels done well beats six done poorly.
3. **Pricing too low.** Underpricing signals low value and attracts wrong customers.
4. **No sales enablement.** Marketing generates leads that sales can't close = wasted money.
5. **Ignoring existing customers.** Expansion revenue is 3x cheaper than new logos.
6. **Vanity metrics.** Traffic and impressions don't pay rent. Track pipeline and revenue.
7. **No kill criteria.** Define upfront what "not working" looks like, or you'll fund losers forever.

## Industry-Specific GTM Considerations

| Industry | Key GTM Factor | Typical Sales Cycle | Best Channel |
|----------|----------------|--------------------:|-------------|
| **SaaS** | Product-led growth + content | 30-90 days | Free trial + SEO |
| **Fintech** | Compliance messaging + trust | 90-180 days | Outbound + events |
| **Healthcare** | HIPAA/regulatory proof | 180-365 days | Referrals + conferences |
| **Legal** | Risk reduction positioning | 90-180 days | Partner referrals |
| **Construction** | ROI on time savings | 60-120 days | Industry events + reps |
| **Ecommerce** | Speed to value + integrations | 14-30 days | Paid ads + marketplace |
| **Real Estate** | Local market knowledge | 30-90 days | Referrals + local SEO |
| **Recruitment** | Placement speed metrics | 30-60 days | LinkedIn + outbound |
| **Manufacturing** | Downtime reduction proof | 90-180 days | Trade shows + reps |
| **Professional Services** | Thought leadership + case studies | 60-120 days | Content + referrals |

For industry-specific AI agent context packs with deeper GTM frameworks, competitive analysis templates, and automation playbooks: **[AfrexAI Context Packs — $47 each](https://afrexai-cto.github.io/context-packs/)**

## Tools

- **[AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find where you're losing money before you spend on GTM
- **[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)** — Configure AI agents to automate your GTM channels
- **Bundle deals:** Pick 3 for $97 | All 10 for $197 | Everything Bundle $247

---
*Built by AfrexAI — turning AI agent expertise into business results.*
