# Growth Engineering Mastery 🚀

Complete growth system for startups and scaling companies. From zero users to exponential growth through systematic experimentation, viral mechanics, and data-driven optimization.

## What This Skill Does

Turns your AI agent into a growth engineering partner that can:

- **Diagnose** your growth health across 8 dimensions with a scored audit
- **Design experiments** using ICE scoring and rigorous A/B testing methodology
- **Optimize every funnel stage** — acquisition, activation, retention, revenue, referral
- **Engineer virality** — K-factor optimization, referral program design, growth loops
- **Scale channels** — 12 channel playbooks with evaluation matrices and scaling criteria
- **Track metrics** — NSM framework, cohort analysis, weekly growth reviews

## Install

```bash
clawhub install afrexai-growth-engine
```

## Quick Start

```
"Run a growth audit on my SaaS product"
"Help me design a referral program"
"Score this experiment idea: adding social proof to pricing page"
"Analyze my signup-to-activation funnel"
"Build a growth loop for my marketplace"
```

## What's Inside

| Section | What You Get |
|---------|-------------|
| Growth Audit | 8-dimension health scorecard + PMF validation gate |
| North Star Metric | Selection framework + examples by business type |
| Experimentation Engine | ICE scoring, experiment templates, statistical rigor rules |
| AARRR Funnel | Stage-by-stage playbooks with benchmarks |
| Viral Mechanics | K-factor optimization, 5 virality types, referral program template |
| Growth Loops | 6 self-reinforcing loop templates |
| CRO Playbook | Conversion benchmarks, landing page checklist, high-impact experiments |
| Retention System | Lifecycle emails, churn prediction, re-engagement sequences |
| Scaling Framework | Channel saturation criteria, international expansion checklist |
| Growth Team | Team structures, meeting cadences, hiring guide |
| Analytics Setup | Full tech stack recommendations, UTM conventions, event tracking plan |

## ⚡ Level Up

This free skill gives you the growth methodology. For industry-specific growth playbooks with vertical-targeted experiments, channel recommendations, and conversion benchmarks:

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**

Available for: SaaS, Fintech, Healthcare, Legal, Construction, Ecommerce, Real Estate, Recruitment, Manufacturing, Professional Services.

## 🔗 More Free Skills by AfrexAI

- `afrexai-seo-content-engine` — SEO content strategy and optimization
- `afrexai-social-media-engine` — Multi-platform social media system
- `afrexai-sales-playbook` — Complete B2B sales methodology
- `afrexai-customer-success` — Retention and expansion revenue
- `afrexai-brand-strategy` — Brand positioning and GTM

Browse all: [AfrexAI on ClawHub](https://clawhub.com)

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
