# Grant Writer

Write winning grant proposals and funding applications. Works for government grants (SBIR, Innovate UK, Horizon Europe), foundation grants, and corporate funding programs.

## What It Does

Takes your project details and produces a complete, submission-ready grant application:

- **Needs Statement** — data-backed problem definition with citations
- **Project Narrative** — methodology, timeline, milestones, deliverables
- **Budget Justification** — line-item budget with cost rationale
- **Evaluation Plan** — measurable outcomes, KPIs, success criteria
- **Sustainability Plan** — how the project continues post-funding
- **Letters of Support** — draft templates for partners/stakeholders

## Usage

Tell the agent:
1. **Grant program** — which funder and call (e.g., "SBIR Phase I", "Innovate UK Smart Grant")
2. **Organization** — who you are, what you do, team size
3. **Project** — what you want to build, the problem it solves, who benefits
4. **Budget** — total ask, major cost categories
5. **Timeline** — project duration and key milestones

The agent will research the funder's priorities, match your project to their criteria, and draft each section using grant-writing best practices.

## Grant-Writing Framework

### Structure (follows standard federal/foundation format)
1. **Cover Letter** — 1 page, hooks the reviewer
2. **Executive Summary** — 250 words, problem → solution → impact → ask
3. **Statement of Need** — data-driven, cites 3-5 sources, quantifies the gap
4. **Goals & Objectives** — SMART format (Specific, Measurable, Achievable, Relevant, Time-bound)
5. **Methods & Approach** — what you'll do, step by step, with justification
6. **Evaluation** — how you'll measure success, what data you'll collect
7. **Budget & Justification** — every dollar explained, tied to activities
8. **Organizational Capacity** — why your team can deliver
9. **Sustainability** — life after the grant ends

### Scoring Tips (built into every draft)
- Lead with impact, not technology
- Use the funder's language — mirror their strategic plan
- Quantify everything: people served, dollars saved, outcomes improved
- Show collaboration — funders want ecosystems, not islands
- Budget should be 10-15% of narrative length
- Include a logic model if the funder uses one

### Common Mistakes the Agent Avoids
- Vague objectives ("improve outcomes" → "reduce processing time by 40% within 12 months")
- Budget padding without justification
- Ignoring the evaluation criteria weights
- Writing to impress instead of writing to score
- Missing the "so what?" — always connect to funder priorities

## Tips

- Run this skill once per grant program — it tailors language to each funder
- Paste the actual RFP/call text for best results
- Ask the agent to score your draft against the rubric before submitting
- Use with the [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) for industry-specific data and language
