# Go Production Engineering 🐹

Build production-grade Go services with battle-tested patterns. From project architecture through deployment — every phase covered with code examples, decision matrices, and quality scoring.

## Install

```bash
clawhub install afrexai-go-production
```

## What's Inside

A complete 14-phase Go production engineering system:

- **Project Architecture** — Standard layout, dependency injection, framework selection matrix
- **Error Handling** — Sentinel errors, wrapping with `%w`, HTTP error mapping
- **Concurrency Patterns** — Context propagation, errgroup, goroutine lifecycle, race prevention
- **Interface Design** — Consumer-defined interfaces, the Go way
- **Testing** — Table-driven tests, testcontainers integration, fuzz testing, benchmarks
- **Configuration** — 12-factor config with validation at startup
- **Structured Logging** — slog (stdlib), request ID middleware
- **Database Patterns** — pgx connection pool, sqlc type-safe SQL, transactions
- **HTTP API Design** — chi router, request/response patterns, health checks
- **Observability** — OpenTelemetry tracing, Prometheus metrics
- **Production Deployment** — Multi-stage Dockerfile, Makefile, GitHub Actions CI
- **Performance** — pprof profiling, connection pooling, sync.Pool, pre-allocation
- **Security** — govulncheck, security headers, input validation, rate limiting
- **Advanced Patterns** — Generics, functional options, circuit breaker

Plus: 10 Commandments, 10 common mistakes table, production readiness checklist, quality scoring rubric.

## Quick Start

Ask your agent:
- "Set up a new Go service" — full project scaffold
- "Review this Go code" — health check + anti-pattern detection
- "Make this production ready" — complete readiness checklist
- "Add observability" — OTel + Prometheus setup

## ⚡ Level Up

Want production-grade patterns for your specific industry?

**[AfrexAI Context Packs ($47)](https://afrexai-cto.github.io/context-packs/)** — Complete AI agent configurations for SaaS, Fintech, Healthcare, Legal, and 6 more verticals.

## 🔗 More Free Skills by AfrexAI

- [afrexai-python-production](https://clawhub.com/skill/afrexai-python-production) — Python production engineering
- [afrexai-nextjs-production](https://clawhub.com/skill/afrexai-nextjs-production) — Next.js production patterns
- [afrexai-react-production](https://clawhub.com/skill/afrexai-react-production) — React production engineering
- [afrexai-cicd-engineering](https://clawhub.com/skill/afrexai-cicd-engineering) — CI/CD pipeline architecture
- [afrexai-database-engineering](https://clawhub.com/skill/afrexai-database-engineering) — Database engineering methodology

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
