# 🔀 AfrexAI Git Engineering & Repository Strategy

Complete methodology for designing branching strategies, implementing code review workflows, managing monorepos, automating releases, and maintaining healthy repositories at scale.

## Install

```bash
clawhub install afrexai-git-engineering
```

## What's Inside

- **Branching Strategy Selection** — Decision matrix for GitHub Flow, GitFlow, Trunk-Based, GitLab Flow, Release Flow
- **Commit Engineering** — Conventional commits, atomic changes, interactive rebase, signing
- **Code Review Mastery** — PR templates, size guidelines, review SLAs, comment taxonomy, approval rules
- **Branch Protection & CI** — Protection configs, pre-merge pipeline, CODEOWNERS
- **Release Automation** — SemVer, automated changelog, tool comparison (semantic-release, release-please, changesets)
- **Monorepo Strategy** — Decision matrix, tooling (Turborepo/Nx/Bazel), affected-only CI, sparse checkout
- **Git Security** — Secrets prevention, commit signing, emergency credential rotation
- **Advanced Workflows** — Trunk-based, database migrations, dependency updates, git hooks
- **Performance** — LFS, sparse checkout, shallow clone, fsmonitor
- **Troubleshooting** — Recovery procedures, emergency playbooks, common fixes
- **Health Dashboard** — Weekly metrics YAML with benchmarks

## Quick Start

Tell your agent: *"Set up git for our 8-person SaaS team deploying daily"*

It will recommend GitHub Flow or Trunk-Based Development, generate branch protection config, PR template, commit conventions, CI pipeline, and CODEOWNERS — ready to copy into your repo.

## ⚡ Level Up

Want the complete engineering playbook for your industry?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** — Deep industry knowledge for AI agents covering SaaS, Fintech, Healthcare, Legal, and more.

## 🔗 More Free Skills by AfrexAI

- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — CI/CD & DevOps methodology
- [afrexai-engineering-effectiveness](https://clawhub.com/skills/afrexai-engineering-effectiveness) — DORA metrics & developer productivity
- [afrexai-platform-engineering](https://clawhub.com/skills/afrexai-platform-engineering) — Internal developer platforms
- [afrexai-test-automation-engineering](https://clawhub.com/skills/afrexai-test-automation-engineering) — Test strategy & automation
- [afrexai-vibe-coding](https://clawhub.com/skills/afrexai-vibe-coding) — AI-assisted development mastery

🖤💛 Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
