# Franchise Operations Analyzer

Evaluate franchise opportunities and manage multi-unit operations with data-driven frameworks.

## What This Does
- **FDD Analysis**: Break down all 23 Items of the Franchise Disclosure Document
- **Unit Economics**: Model startup costs, breakeven timeline, and cash flow projections
- **Territory Analysis**: Evaluate market saturation, demographics, and site selection criteria
- **Royalty Impact Modeling**: Calculate true cost of royalties + ad fund on unit profitability
- **Multi-Unit Scaling**: Expansion planning with shared overhead and management layering
- **Compliance Calendar**: Track FTC Rule obligations, state registration renewals, relationship laws

## Usage

Tell the agent what you need:

- "Analyze this franchise FDD for red flags"
- "Model unit economics for a QSR franchise at $450K investment"
- "Compare royalty structures across these 3 franchise systems"
- "Build a 5-year multi-unit expansion plan"
- "What are the franchise compliance requirements in California?"

## FDD Item 19 Analysis Framework

Item 19 (Financial Performance Representations) is where franchisors show earnings data — or don't.

### If Item 19 is provided:
1. Check sample size (what % of units are included?)
2. Median vs mean revenue (mean gets skewed by top performers)
3. Time period covered (pandemic years? expansion years?)
4. Geographic breakdown (national average hides regional variance)
5. Unit age distribution (mature units outperform new ones)

### If Item 19 is blank:
- Not illegal, but ask why. 40% of franchisors skip it.
- Use Item 21 (financial statements) + Item 20 (outlet count/closures) to reverse-engineer.

## Unit Economics Template

```
INVESTMENT ANALYSIS
━━━━━━━━━━━━━━━━━━
Initial Franchise Fee:     $________
Build-out & Equipment:     $________
Working Capital (6 mo):    $________
Total Investment:          $________

MONTHLY P&L MODEL
━━━━━━━━━━━━━━━━━━
Gross Revenue:             $________
  - COGS (____%):          $________
Gross Profit:              $________
  - Royalty (____%):       $________
  - Ad Fund (____%):       $________
  - Rent:                  $________
  - Labor:                 $________
  - Insurance:             $________
  - Utilities:             $________
  - Other OpEx:            $________
Net Operating Income:      $________

BREAKEVEN
━━━━━━━━━━━━━━━━━━
Monthly Breakeven Revenue: $________
Months to Breakeven:       ________
Cash-on-Cash Return (Y1):  ________%
Payback Period:            ________ months
```

## Royalty Impact Calculator

True royalty cost is higher than the percentage suggests:

| Royalty Rate | On $1M Revenue | On $500K Profit | Effective Profit Impact |
|-------------|---------------|----------------|----------------------|
| 4% | $40,000 | — | 8.0% of profit |
| 6% | $60,000 | — | 12.0% of profit |
| 8% | $80,000 | — | 16.0% of profit |

Add advertising fund (typically 1-3%) for total franchisor take.

## FDD Red Flags Checklist

- [ ] Item 3: Litigation history — active lawsuits from franchisees?
- [ ] Item 5: Initial fees — are they refundable under any condition?
- [ ] Item 6: Ongoing fees — hidden technology/supply fees beyond royalty?
- [ ] Item 7: Investment range — is the spread too wide (signals uncertainty)?
- [ ] Item 8: Sourcing restrictions — must you buy from franchisor-approved suppliers only?
- [ ] Item 9: Franchisee obligations — non-compete scope and duration?
- [ ] Item 11: Franchisor obligations — what training/support is actually guaranteed?
- [ ] Item 12: Territory — is it exclusive? What's the protected radius?
- [ ] Item 17: Renewal terms — can they change royalty rates at renewal?
- [ ] Item 19: Financial performance — present or absent? Representative sample?
- [ ] Item 20: Unit counts — net openings vs closures over 3 years
- [ ] Item 21: Financial statements — is the franchisor itself profitable?

## Franchise State Registration Requirements

13 states require franchise registration before selling:
California, Hawaii, Illinois, Indiana, Maryland, Michigan, Minnesota, New York, North Dakota, Rhode Island, South Dakota, Virginia, Washington, Wisconsin

Additional filing states: Connecticut, Florida, Kentucky, Nebraska, Texas, Utah

## Multi-Unit Expansion Model

| Units | Shared Overhead Savings | Management Layer | Typical Net Margin Lift |
|-------|------------------------|-------------------|----------------------|
| 1 | Baseline | Owner-operator | — |
| 2-3 | 15-20% G&A reduction | Area manager needed | +2-4% |
| 4-6 | 25-30% G&A reduction | District manager | +3-5% |
| 7-10 | 30-40% G&A reduction | Regional structure | +4-7% |
| 10+ | 40%+ G&A reduction | Corporate office | +5-8% |

## Franchise vs Independent Business Comparison

| Factor | Franchise | Independent |
|--------|-----------|-------------|
| Failure rate (5yr) | ~15% | ~50% |
| Brand recognition | Immediate | Build from zero |
| Startup cost | Higher (franchise fee) | Lower but variable |
| Operational freedom | Limited by system | Complete |
| Financing access | Easier (SBA loves franchises) | Harder |
| Exit/resale | Structured transfer process | Negotiated |
| Ongoing costs | Royalties + ad fund | None mandated |

---

**Need help evaluating franchise opportunities or building operational systems for multi-unit businesses?**

→ [Browse AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — industry-specific agent configs starting at $47
→ [Calculate Your AI Revenue Opportunity](https://afrexai-cto.github.io/ai-revenue-calculator/)
→ [Get Your Custom Agent Setup](https://afrexai-cto.github.io/agent-setup/)
