# Franchise Operations Analyzer

Evaluate franchise opportunities, analyze FDDs, model unit economics, and plan multi-unit expansion.

Built for franchise buyers, multi-unit operators, franchise consultants, and franchise development teams.

## Features

- **FDD Red Flag Detection** — Systematic review of all 23 Franchise Disclosure Document items
- **Unit Economics Modeling** — Startup costs, breakeven analysis, cash-on-cash returns
- **Royalty Impact Calculator** — True profit impact of royalty + ad fund structures
- **Territory & Site Analysis** — Market saturation, demographics, protected territory evaluation
- **Multi-Unit Scaling** — Shared overhead savings, management layering, expansion planning
- **Compliance Tracking** — State registration requirements, FTC Rule obligations, renewal deadlines

## Who This Is For

- **Prospective franchisees** evaluating their first (or next) franchise purchase
- **Multi-unit operators** planning expansion across territories
- **Franchise consultants** analyzing opportunities for clients
- **Franchise development teams** benchmarking against competitors

## Quick Start

Ask your agent:
- "Analyze this franchise FDD for red flags"
- "Model unit economics for a $450K QSR investment"
- "Compare royalty structures across 3 franchise systems"
- "What states require franchise registration?"

## Links

- [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — $47/pack
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
