# AfrexAI FP&A Command Center

Your AI-powered Financial Planning & Analysis engine. Build financial models, run variance analysis, manage cash flow, and produce board-ready reports — all through natural language.

## Install

```bash
clawhub install afrexai-fpa-engine
```

## What It Does

- **Revenue forecasting** — Driver-based models with 3 scenarios (bear/base/bull)
- **Budget management** — Annual budgets, monthly variance analysis, zero-based budgeting
- **Cash flow** — 13-week rolling forecast, runway calculations, working capital optimization
- **Unit economics** — CAC, LTV, burn multiple, magic number, Rule of 40 with health scoring
- **Board reporting** — Complete financial package with executive summary, P&L, KPIs
- **Financial modeling** — Full model architecture with sensitivity analysis
- **Fundraising prep** — Data room checklist, valuation benchmarks, investor-ready metrics

## Quick Start

Just tell your agent what you need:

- "Build a 3-year financial model for our SaaS business"
- "Analyze last month's P&L — here are the numbers..."
- "How much runway do we have at current burn?"
- "Prepare the board financial package for Q1"
- "Run unit economics — our CAC is $500, MRR per customer is $200, churn is 3%"

## Who It's For

- Startup founders managing finances without a CFO
- FP&A analysts who want AI-assisted modeling
- CEOs preparing board packages
- Anyone doing financial planning, budgeting, or fundraising prep

## ⚡ Level Up

Need industry-specific financial frameworks? Our **Context Packs** ($47) include tailored financial models, KPI benchmarks, and pricing strategies for your vertical:

- **SaaS Pack** — SaaS-specific metrics, pricing tiers, expansion revenue modeling
- **Fintech Pack** — Regulatory capital, payment economics, fraud cost modeling
- **Manufacturing Pack** — COGS optimization, inventory financing, capacity planning
- **Professional Services Pack** — Utilization-based revenue, project profitability, rate optimization

→ [Browse all packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-budget-tracker](https://clawhub.com/skills/afrexai-budget-tracker) — Personal & business budget management
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Complete pricing system
- [afrexai-founder-os](https://clawhub.com/skills/afrexai-founder-os) — Startup operating system
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — B2B sales methodology
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — Data analysis frameworks

→ [All AfrexAI skills on ClawHub](https://clawhub.com/publishers/afrexai)

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛*
