# Founder OS — Complete Startup Operating System 🚀

Your AI startup advisor — from idea validation to Series A and beyond.

## What This Skill Does

Turns your AI agent into a startup co-pilot that covers every phase of building a company:

- **Idea Validation** — Customer discovery scripts, kill criteria, interview synthesis
- **MVP & Launch** — Scope matrix, launch checklists, feedback loops
- **Product-Market Fit** — Sean Ellis test, retention tracking, pivot decision framework
- **Unit Economics** — LTV:CAC, burn multiple, magic number, pricing frameworks
- **Fundraising** — Round benchmarks, pitch deck structure, VC meeting playbook
- **Team Building** — Hiring priority order, compensation bands, equity guidelines
- **Financial Planning** — Runway scenarios, cash management rules
- **Founder Psychology** — Energy management, burnout signals, decision frameworks
- **Scaling** — Readiness checklist, growth lever stack

## Install

```bash
clawhub install afrexai-founder-os
```

## Quick Start

Just tell your agent:
- "Validate my startup idea for [description]"
- "Am I ready to raise a seed round?"
- "Help me price my SaaS product"
- "Review my pitch deck"
- "Check my unit economics — CAC is $200, LTV is $800"
- "I'm burning out, help"

## What Makes This Different

Other founder skills give you bullet-point advice. This gives you:
- Fill-in YAML templates for every critical document
- Exact scripts for customer discovery interviews
- Quantitative frameworks (40% Ellis test, 3:1 LTV:CAC, burn multiple)
- Decision matrices, not vague guidance
- Compensation bands and equity allocation tables
- Scenario planning templates for your runway

## ⚡ Level Up

Get the complete **SaaS Context Pack** ($47) — includes agent memory files for SaaS metrics, competitive positioning, growth playbooks, and more:

🛒 [Browse all context packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — Complete B2B sales system
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Value-based pricing framework
- [afrexai-pitch-deck-reviewer](https://clawhub.com/skills/afrexai-pitch-deck-reviewer) — Score your deck
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — Competitive intelligence system
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — Data analysis methodology

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
