# Food Truck Business Operations

Complete operational playbook for launching and scaling a food truck business. Covers menu engineering, pricing, permits, commissary kitchens, route planning, event booking, and growth from 1 truck to a fleet.

## Menu Engineering & Pricing

### Food Cost Targets by Concept
| Concept | Target Food Cost | Avg Ticket | Items on Menu |
|---------|-----------------|------------|---------------|
| Tacos / Mexican | 28-32% | $12-15 | 8-12 |
| BBQ / Smoked Meat | 30-35% | $14-18 | 6-10 |
| Burgers | 28-32% | $13-16 | 6-8 |
| Asian Fusion | 25-30% | $13-17 | 8-12 |
| Pizza | 22-28% | $12-15 | 6-8 |
| Desserts / Ice Cream | 20-28% | $8-12 | 8-15 |
| Coffee / Beverage | 15-22% | $6-9 | 10-15 |
| Vegan / Health | 28-33% | $14-18 | 8-10 |

### Menu Size Rule
Keep it to 8-12 items MAX. Every item you add slows service, increases waste, and complicates prep. The best trucks run 6 items and crush it.

### Pricing Formula
```
Menu Price = (Ingredient Cost / Target Food Cost %) × 1.0
Example: $3.50 ingredients / 0.30 = $11.67 → price at $12
```

### High-Margin Adds
- Drinks (80%+ margin): bottled water $2-3, canned soda $2-3, fresh lemonade $4-5
- Sides: chips $3, mac & cheese $4-5, coleslaw $3
- Desserts: cookies $3-4, churros $5-6
- Upsell combos: meal + drink + side = $3-5 more per ticket

## Startup Costs

### New Truck Build
| Item | Cost Range |
|------|-----------|
| Used truck (turnkey) | $40,000-80,000 |
| New custom build | $80,000-200,000 |
| Wrap / branding | $2,500-5,000 |
| POS system (Square/Clover) | $500-1,500 |
| Initial inventory | $1,000-3,000 |
| Permits & licenses | $1,000-5,000 |
| Insurance (annual) | $2,000-4,000 |
| Commissary deposit | $500-2,000 |
| Generator (if needed) | $3,000-8,000 |
| Fire suppression system | $3,000-6,000 |
| **Total range** | **$53,500-234,500** |

### Trailer Alternative
Food trailers run $20,000-60,000 — roughly half a truck. Trade-off: need a tow vehicle, harder to park in tight spots, but way cheaper entry point.

## Permits & Licensing (US)

### Required Everywhere
- **Business license** — city/county, $50-500/year
- **Food handler's permit** — per person, $10-25, ServSafe or equivalent
- **Health department permit** — $200-1,000/year, requires inspection
- **Fire department permit** — fire suppression system inspection, $100-300
- **Vehicle registration** — commercial plates
- **Sales tax permit** — state-issued

### Varies by City/State
- **Mobile food vendor permit** — some cities cap the number issued
- **Commissary kitchen requirement** — most cities require you prep/store at a licensed commissary
- **Parking permits** — specific zones, meters, or private lot agreements
- **Special event permits** — per-event, $25-200
- **Propane use permit** — some jurisdictions require separate approval

### Cities Known for Tough Regulations
Portland, OR — lottery system for downtown spots
Boston, MA — very limited permits, long waitlists
NYC — extremely expensive medallion-style permits
Austin, TX — relatively friendly, lots of food truck parks

### Cities Known for Food Truck Friendly Policies
Los Angeles, CA | Houston, TX | Denver, CO | Nashville, TN | Miami, FL

## Daily Operations

### Prep Day Timeline
```
6:00 AM  — Arrive at commissary, prep ingredients
8:00 AM  — Load truck, check equipment, ice down
9:00 AM  — Drive to location, set up
9:30 AM  — Systems check: POS, generator, propane, water
10:00 AM — Open for service
2:00 PM  — Lunch rush ends, restock if doing dinner
5:00 PM  — Dinner service (if applicable)
8:00 PM  — Close, clean, drive to commissary
9:00 PM  — Unload, deep clean, prep for tomorrow
```

### Daily Checklist
- [ ] Propane tank level (swap at 20%)
- [ ] Fresh water tank full
- [ ] Grey water tank empty
- [ ] Generator fuel and oil
- [ ] POS charged and connected
- [ ] Menu board clean and visible
- [ ] Hand wash station stocked (soap, paper towels)
- [ ] Thermometer readings logged (cold hold <41°F, hot hold >135°F)
- [ ] Cash drawer counted
- [ ] Social media post (location + hours)

## Route Planning & Revenue

### Location Types by Revenue Potential
| Location | Avg Daily Revenue | Fee Structure |
|----------|------------------|---------------|
| Brewery / Taproom | $800-2,000 | Free or $50-100 |
| Office Park (lunch) | $600-1,500 | Free-$100/day |
| Farmers Market | $500-1,500 | $50-150 booth fee |
| Festival / Event | $2,000-8,000+ | 10-20% of sales or flat $200-500 |
| Food Truck Park | $400-1,200 | $500-2,000/month rent |
| Private Catering | $1,500-5,000+ | Negotiated per-head |
| Construction Site | $400-800 | Usually free |
| Late Night (bars) | $500-1,500 | Free or $50-100 |

### Weekly Revenue Model (Single Truck)
```
Tuesday:    Office park lunch      $800
Wednesday:  Brewery                $1,000
Thursday:   Office park lunch      $900
Friday:     Late night bar strip   $1,200
Saturday:   Farmers market AM      $1,000
Saturday:   Event/festival PM      $2,500
Sunday:     Brunch spot            $800
                                   --------
Weekly total:                      $8,200
Monthly (4.3 weeks):               $35,260
Annual:                            $423,000
```

### Seasonality Index (% of Peak Revenue)
| Month | Index | Notes |
|-------|-------|-------|
| Jan | 50% | Cold weather, post-holiday |
| Feb | 55% | Still slow |
| Mar | 65% | Starting to warm up |
| Apr | 80% | Spring events begin |
| May | 90% | Wedding/graduation season |
| Jun | 100% | Peak season starts |
| Jul | 100% | Peak |
| Aug | 95% | Still strong |
| Sep | 85% | Back to school |
| Oct | 75% | Fall festivals |
| Nov | 60% | Holiday prep |
| Dec | 55% | Cold, but holiday events |

## Financial Benchmarks

### P&L Targets (% of Revenue)
| Line Item | Target % |
|-----------|----------|
| Food cost (COGS) | 28-35% |
| Labor (including owner) | 25-30% |
| Fuel (truck + generator) | 3-5% |
| Commissary rent | 3-5% |
| Insurance | 1-2% |
| Permits & licenses | 1-2% |
| POS / payment processing | 3-4% |
| Marketing | 2-3% |
| Maintenance & repairs | 3-5% |
| **Net profit** | **15-25%** |

### Break-Even Calculation
```
Monthly fixed costs: ~$4,000-6,000
(commissary $800, insurance $300, permits $200, truck payment $1,500, phone/POS $200, marketing $200, misc $500)

Contribution margin: ~60% (after food cost + payment processing)

Break-even monthly revenue: $4,500 / 0.60 = $7,500-10,000
Break-even daily (20 days): $375-500/day
```

Most trucks need $500/day minimum to survive. $1,000/day is comfortable. $2,000/day is thriving.

## Commissary Kitchen

### What You Need From a Commissary
- Licensed commercial kitchen for prep
- Dry and cold storage
- Grease trap access
- Overnight truck parking
- Waste disposal
- Health department approved

### Cost Range
- Shared commissary: $500-1,500/month
- Dedicated space: $1,500-3,000/month
- Ghost kitchen rental: $2,000-5,000/month (overkill for most trucks)

## Growth: 1 Truck → Fleet

### Stage 1: Single Truck ($0-300K/year)
- Owner-operated, 1-2 employees
- Focus: nail the menu, build following, consistent locations
- Reinvest everything

### Stage 2: Optimized Single ($300-500K/year)
- 2-3 employees, owner steps back from daily cooking
- Add catering revenue stream
- Build SOPs so others can run the truck without you

### Stage 3: Second Truck ($500K-1M/year)
- Clone the model — same menu, same SOPs
- Different territory / different schedule
- Hire a truck manager, not just cooks
- Shared commissary, shared purchasing = better margins

### Stage 4: Fleet (3+ trucks, $1M+/year)
- Central commissary for all trucks
- Bulk purchasing (food cost drops 3-5%)
- Brand licensing or franchise model
- Consider brick-and-mortar as anchor location

### Key Metrics to Track
- **Revenue per service hour** — target $150-300/hr
- **Tickets per hour** — target 30-60 during rush
- **Average ticket** — track weekly, push combos to raise it
- **Food cost %** — weigh everything, price monthly
- **Waste %** — track and reduce, target <3% of food purchased
- **Social followers** — your free marketing channel
- **Repeat customer rate** — loyalty cards, apps

## Marketing That Works

### Free / Low-Cost
- Instagram + TikTok (post your location DAILY)
- Google Business Profile (show up in "food trucks near me")
- Yelp listing (free, people search it)
- Text/email list — collect at every stop, send weekly schedule
- Partner with breweries, offices, event planners

### Paid (When Profitable)
- Instagram/Facebook ads ($5-10/day, geo-targeted)
- Food truck finder apps (Roaming Hunger, Street Food Finder)
- Sponsor local events for visibility

### The #1 Marketing Rule
Post your location and hours EVERY SINGLE DAY on social media. The question "where are you today?" should never go unanswered.

## Common Mistakes

1. **Menu too big** — more items = more waste, slower service, confused customers
2. **Ignoring weather** — rain drops revenue 40-60%. Have backup indoor spots.
3. **No commissary plan** — operating without one is illegal in most cities
4. **Underpricing** — you're not competing with McDonald's. Charge what you're worth.
5. **Skipping maintenance** — a broken truck = zero revenue. Budget 3-5% for maintenance.
6. **No social media presence** — if people can't find you, you don't exist
7. **Bad location research** — one bad spot can waste an entire day
8. **No catering** — highest-margin revenue stream, most trucks ignore it

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI-powered business operations context for agents and founders.*

*Need the full AI agent context pack for your industry? Browse all 10 at our [storefront](https://afrexai-cto.github.io/context-packs/) — $47 each or grab the complete bundle for $197.*
