# Food Safety & HACCP Compliance Agent 🍽️

Turn your AI agent into a food safety expert. Build HACCP plans, run compliance audits, manage allergens, and stay ahead of FDA/USDA requirements — without hiring a $150/hr consultant.

## What's Inside

- **Complete HACCP plan builder** — all 7 principles with scientific critical limits, CCP decision tree, and monitoring templates
- **Hazard analysis framework** — biological, chemical, and physical hazard evaluation for every process step
- **Prerequisite programs** — supplier approval, allergen management (Big 9), sanitation, pest control, personal hygiene, training
- **Regulatory mapping** — FDA FSMA Preventive Controls, USDA-FSIS HACCP, Seafood/Juice HACCP, state requirements
- **Third-party audit prep** — SQF, BRC, FSSC 22000, IFS, Primus GFS readiness
- **Recall readiness** — classification system, mock recall protocol, FDA Reportable Food Registry requirements
- **Temperature reference** — every critical cooking, holding, and cooling temp with FDA Food Code citations

## Who This Is For

- Restaurant operators and kitchen managers
- Food manufacturers and co-packers
- Quality assurance teams
- Food safety consultants building client plans
- Commissary kitchens and ghost kitchens
- Food truck and catering operations
- Anyone facing a health department or third-party audit

## Quick Start

Install in OpenClaw and ask your agent to:

- "Build a HACCP plan for our frozen pizza production line"
- "Audit our restaurant's food safety program"
- "Create an allergen management plan for our bakery"
- "What are the FSMA Preventive Controls requirements for our facility?"
- "Run a mock recall for lot code BK-2026-0224"

## Why This Exists

Food safety violations shut businesses down. The average FDA warning letter costs $200K+ in remediation. A single Listeria recall averages $10M. Most small and mid-size operations can't afford a full-time food safety manager, and consultants charge $150-300/hr.

This skill gives your AI agent the same knowledge framework — FDA Food Code citations, USDA performance standards, GFSI audit criteria — so you can build plans, run internal audits, and catch problems before an inspector does.

## Get the Full Package

This skill covers food safety and HACCP. For complete industry-specific AI agent configurations:

🔗 **[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 per industry. Manufacturing, healthcare, legal, construction, and more.

🔗 **[AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find out what AI automation saves your operation.

🔗 **[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)** — Configure your AI agent stack in 5 minutes.

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI agents that actually know your industry.
