# Fleet Management Optimizer

Turn your AI agent into a fleet operations analyst. Utilization tracking, maintenance scheduling, replacement decisions, route optimization, and EV transition planning — all from natural language.

## What It Does

- **Utilization analysis** — find underused vehicles costing you money
- **Maintenance scheduling** — preventive calendars, cost-per-mile tracking
- **TCO modeling** — full lifecycle cost across acquisition, fuel, maintenance, insurance, depreciation
- **Replacement timing** — data-driven decisions on when to replace vs repair
- **Fleet right-sizing** — cut 15-25% of fleet costs by eliminating waste
- **EV transition planning** — ICE vs EV TCO comparison with phased rollout

## Who It's For

Fleet managers, operations directors, logistics companies, construction firms, delivery services, field service businesses — anyone running 10+ vehicles.

## The Numbers

- Average fleet runs at 65% utilization (industry data)
- Right-sizing saves $8,000-$12,000/vehicle/year
- Preventive maintenance reduces breakdowns by 25-30%
- Optimized replacement cycles save 18-22% on lifecycle costs

## Quick Start

Install on OpenClaw and ask:

```
"Analyze my fleet of 45 vehicles — here are the last 90 days of mileage and maintenance data"
"When should I replace my 2019 Ford Transit vans?"
"Build an EV transition plan for my delivery fleet"
"What's my cost per mile by vehicle class?"
```

## More Business Operations Tools

This skill is part of the AfrexAI operations toolkit:

- 🏭 [Manufacturing Context Pack](https://afrexai-cto.github.io/context-packs/) — production scheduling, quality control, supply chain ($47)
- 🏗️ [Construction Context Pack](https://afrexai-cto.github.io/context-packs/) — project tracking, safety compliance, resource allocation ($47)
- 📊 [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where you're losing money to manual processes (free)
- 🤖 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — configure your AI agent in 5 minutes (free)

**Browse all packs:** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
