# 🏋️ Fitness & Training Engineering by AfrexAI

Complete periodized training system — program design, progressive overload, recovery optimization, body composition, and race prep. Works for any goal: strength, hypertrophy, endurance, hybrid (Hyrox/CrossFit), or general fitness.

## Install

```bash
clawhub install afrexai-fitness-engine
```

## What You Get

- **8-signal training health check** with /16 scoring
- **Periodization models** — linear, undulating, block, conjugate, hybrid
- **Complete programs** — Beginner Full Body, Intermediate Upper/Lower, Hyrox 12-Week Prep
- **Exercise selection** — movement pattern requirements, rep range guides, RPE scale
- **Volume landmarks** — MEV/MAV/MRV per muscle group with progression rules
- **Running programming** — HR zones, 80/20 rule, conditioning modalities
- **Recovery system** — fatigue monitoring, deload protocols, readiness scoring
- **Nutrition for training** — macro targets by goal, pre/intra/post workout, evidence-based supplements
- **Mobility & injury prevention** — daily routine, warmup protocols, common issue fixes
- **Body composition** — fat loss protocol, muscle gain protocol, recomposition guidance
- **Race prep** — taper protocols, race day checklist
- **Progress tracking** — workout log YAML, weekly review template
- **Plateau troubleshooting** — decision tree for stalled progress

## Quick Start

Ask your agent:
- "Design a 4-day training program for hypertrophy"
- "Score my current program with /fitness-check"
- "Build a 12-week Hyrox prep plan"
- "I'm stuck at 100kg bench — help me break through"
- "Set up my cutting macros at 85kg"

## ⚡ Level Up

Want industry-specific AI context packs for your business?

**[Browse AfrexAI Context Packs →](https://afrexai-cto.github.io/context-packs/)**

$47 each — Healthcare, SaaS, Fintech, and 7 more verticals. Complete agent configurations with industry knowledge, workflows, and automation playbooks.

## 🔗 More Free Skills by AfrexAI

- [afrexai-nutrition-mastery](https://clawhub.com/skills/afrexai-nutrition-mastery) — Complete nutrition & meal planning system
- [afrexai-peak-performance](https://clawhub.com/skills/afrexai-peak-performance) — Productivity & deep work system
- [afrexai-personal-finance](https://clawhub.com/skills/afrexai-personal-finance) — Complete personal finance operating system
- [afrexai-prompt-engineering](https://clawhub.com/skills/afrexai-prompt-engineering) — Master AI prompt engineering
- [afrexai-strategic-thinking](https://clawhub.com/skills/afrexai-strategic-thinking) — Mental models & decision frameworks

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
