# Financial Due Diligence Analyzer

Run M&A-grade financial due diligence on any target. Quality of Earnings, working capital analysis, revenue quality scoring, red flag detection, and valuation sanity checks.

**Who this is for:** PE firms, corporate development teams, search fund operators, founders evaluating acquisitions or partnerships.

## Features

- **Quality of Earnings (QoE)** — EBITDA normalization with 6-category adjustment framework
- **Revenue Quality Score** — 0-100 composite score across 6 factors (recurring %, concentration, retention, backlog, growth, pricing power)
- **Working Capital Peg** — NWC calculation with seasonal normalization
- **Red Flag Scanner** — 23-point checklist ranked Critical / Serious / Notable
- **Valuation Multiples** — 2025-2026 benchmarks across 7 sectors
- **Cash Flow Bridge** — EBITDA to FCF conversion analysis

## Usage

```
Tell your AI agent: "Run financial due diligence on [company]"
```

Provide financials (even partial) and the agent generates a structured diligence package.

## Links

- [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — 10 industry packs, $47 each
- [Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/).
