# 🚀 AfrexAI FastAPI Production Engineering

Complete methodology for building, deploying, and scaling production FastAPI applications. Not a tutorial — a production operating system.

## What This Skill Does

Transforms your FastAPI project from prototype to production-grade with:

- **Project architecture** — Feature-based structure with strict layering
- **Pydantic v2 mastery** — Schema design, validation, generics
- **Error handling** — Structured exception hierarchy with global handler
- **Auth & security** — JWT + RBAC + 10-point security checklist
- **Database patterns** — Async SQLAlchemy + repository pattern + migrations
- **Testing** — Async test patterns with pytest-asyncio + httpx
- **Observability** — Structlog + request tracing + health checks
- **Deployment** — Multi-stage Docker + GitHub Actions CI + production checklist

## Install

```bash
clawhub install afrexai-fastapi-production
```

## Quick Start

Ask your agent:
- `audit my FastAPI project` — get a health score out of 16
- `set up a new FastAPI project` — full structure + config
- `add authentication` — JWT + dependency injection pattern
- `prepare for production` — Dockerfile + CI + checklist

## What Makes This 10X Better

| Feature | Generic Skills | This Skill |
|---------|---------------|------------|
| Architecture | "Use routers" | Full feature-based structure with 7 rules |
| Error handling | `HTTPException(404)` | Custom hierarchy + global handler + structured JSON |
| Auth | Basic JWT example | JWT + RBAC + DI + 10-point security checklist |
| Database | Raw SQLAlchemy | Async + repository pattern + migrations |
| Testing | "Write tests" | Async patterns + fixtures + parametrized + 7 rules |
| Deployment | `uvicorn main:app` | Multi-stage Docker + CI + health checks + checklist |
| Quality | No scoring | 0-100 rubric across 8 weighted dimensions |

## ⚡ Level Up

Get the [AfrexAI SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/) for complete SaaS architecture, pricing strategies, go-to-market playbooks, and more.

## 🔗 More Free Skills by AfrexAI

- [afrexai-python-production](https://clawhub.com/skills/afrexai-python-production) — Python production engineering
- [afrexai-nodejs-production](https://clawhub.com/skills/afrexai-nodejs-production) — Node.js/TypeScript production
- [afrexai-api-architecture](https://clawhub.com/skills/afrexai-api-architecture) — API design methodology
- [afrexai-database-engineering](https://clawhub.com/skills/afrexai-database-engineering) — Database patterns
- [afrexai-test-automation-engineering](https://clawhub.com/skills/afrexai-test-automation-engineering) — Testing strategy

🛒 [Browse all AfrexAI skills](https://afrexai-cto.github.io/context-packs/)
