# Exit Strategy & Business Valuation Planner

Plan your exit before you need one. This skill turns your AI agent into an M&A advisor that builds complete exit readiness packages — valuation estimates, path analysis, readiness scorecards, and value maximization roadmaps.

## What It Does

- **Valuation modeling** — Revenue, EBITDA, and SDE multiples by industry with 2025-2026 benchmarks
- **Exit path comparison** — Strategic acquisition, PE, MBO, IPO, acqui-hire, wind-down side by side
- **Readiness scoring** — 6-dimension scorecard that shows exactly where you're weak
- **Value maximization** — Specific actions to increase your multiple over 6-24 months
- **Deal structure** — Cash vs stock vs earn-out tradeoffs, tax optimization, escrow guidance
- **Timeline** — 12-month exit prep calendar with monthly deliverables

## Who It's For

- Founders planning an exit in 1-3 years
- Business owners evaluating acquisition offers
- CFOs preparing for due diligence
- Investors assessing portfolio company readiness

## Example

> "I run a $4M ARR B2B SaaS with 120% NRR, 30% margins, 50% YoY growth. Team of 22. Thinking about exit in 18 months."

The agent will generate a full exit package: estimated valuation range ($20-48M), recommended path (strategic acquisition), readiness score, and a month-by-month prep plan.

## Want More?

This skill pairs well with industry-specific context packs that give your agent deep domain knowledge:

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — metrics, benchmarks, and playbooks for SaaS businesses ($47)
- **[Fintech Context Pack](https://afrexai-cto.github.io/context-packs/)** — regulatory frameworks and financial modeling ($47)
- **[Professional Services Pack](https://afrexai-cto.github.io/context-packs/)** — utilization, pricing, and client management ($47)

Bundle deals: [Pick 3 for $97](https://afrexai-cto.github.io/context-packs/) | [All 10 for $197](https://afrexai-cto.github.io/context-packs/)

**Free tools:**
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your AI agent in minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — context packs that make AI agents actually useful for business.
