# Executive Coaching & Leadership Development Engine

Complete executive coaching system for AI agents — leadership assessment, 360° feedback, coaching conversations, development planning, executive presence, team effectiveness, and succession planning.

## What This Skill Does

Transforms your AI agent into an executive coach that can:
- Assess leadership effectiveness across 8 dimensions
- Design and debrief 360° feedback surveys
- Run structured coaching conversations using GROW and advanced techniques
- Create 70-20-10 development plans with milestones
- Build executive presence across gravitas, communication, and appearance
- Assess team health using Lencioni + Project Aristotle frameworks
- Guide leaders through career transitions (first 90 days)
- Build succession plans with 9-box talent assessment
- Measure coaching ROI with quantified business impact

## Install

```bash
clawhub install afrexai-executive-coaching
```

## Quick Start

Ask your agent:
- "Assess my leadership effectiveness"
- "Help me prepare for a difficult conversation with my VP"
- "Create a 90-day plan for my new Director role"
- "Coach me on delegation — I can't stop doing IC work"
- "Build a development plan for my high-potential manager"
- "Assess my team's health"

## What's Inside

- **Leadership assessment** with 8-dimension scoring + level-appropriate focus areas
- **360° feedback** survey design + debrief framework
- **50 powerful coaching questions** organized by category
- **GROW model** with advanced techniques (challenging, resistance, somatic)
- **Development plan template** with 70-20-10 action library
- **Executive presence** 4-pillar framework with situation guides
- **Team effectiveness** assessment + full-day offsite design
- **First 90 days** transition framework for new leaders
- **Succession planning** with 9-box calibration
- **5 difficult coaching scenarios** with playbooks
- **100-point quality rubric** for coaching engagements

## ⚡ Level Up

Want complete industry-specific AI agent context packs with coaching, operations, and strategy frameworks?

**[$47 Context Packs](https://afrexai-cto.github.io/context-packs/)** — 10 verticals: SaaS, Healthcare, Legal, Fintech, Construction, Manufacturing, Real Estate, Recruitment, Professional Services, Ecommerce.

## 🔗 More Free Skills by AfrexAI

- [afrexai-engineering-manager](https://clawhub.com/skills/afrexai-engineering-manager) — Engineering management operating system
- [afrexai-strategic-thinking](https://clawhub.com/skills/afrexai-strategic-thinking) — Mental models & decision frameworks
- [afrexai-negotiation-mastery](https://clawhub.com/skills/afrexai-negotiation-mastery) — Complete negotiation system
- [afrexai-okr-engine](https://clawhub.com/skills/afrexai-okr-engine) — OKR design & execution
- [afrexai-peak-performance](https://clawhub.com/skills/afrexai-peak-performance) — Productivity & deep work system

**Browse all AfrexAI skills →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
