# Event Planner Pro 🎪

Plan, execute, and measure business events — from intimate workshops to 5,000+ person conferences.

## Install

```bash
clawhub install afrexai-event-planner
```

## What It Does

Complete event lifecycle management:

- **9 event types** covered (conference, webinar, workshop, networking, trade show, product launch, corporate, fundraiser, retreat)
- **Budget templates** with allocation rules by event type and cost-cutting strategies
- **Master timelines** adaptable from 2-week webinars to 12-month conferences
- **Venue scorecard** (150-point rating system) and vendor management
- **Speaker management** — outreach templates, prep kits, content guidelines
- **Registration & marketing** — pricing tiers, 6-email sequence, landing page checklist
- **Sponsorship system** — 4-tier structure with outreach and ROI packages
- **Day-of execution** — run-of-show template, emergency kit, networking activities
- **Virtual & hybrid** — platform comparison, engagement techniques, hybrid rules
- **ROI calculation** — direct revenue, pipeline value, brand value, verdict framework
- **Post-event** — feedback surveys, content repurposing (7-step, 6-month long tail), lessons learned
- **5 industry guides** — Tech/SaaS, Professional Services, Healthcare, Construction, Real Estate

## Quick Start

```
Plan a 200-person SaaS conference in Austin for Q3
```

```
Create a budget for a 50-person workshop at $200/person
```

```
Build a webinar campaign on [topic] launching in 3 weeks
```

## ⚡ Level Up

Want the complete context for your industry? Our **$47 Context Packs** include event planning frameworks tailored to your vertical, plus outreach sequences, competitive positioning, and operational playbooks:

👉 [Browse Context Packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Meeting prep, agendas, follow-ups
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — Complete B2B sales system
- [afrexai-product-launch](https://clawhub.com/skills/afrexai-product-launch) — 6-phase product launch methodology
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand identity to GTM
- [afrexai-stakeholder-management](https://clawhub.com/skills/afrexai-stakeholder-management) — Manage stakeholders and sponsors

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
