# 🎪 AfrexAI Event Management & Conference Engine

Complete event planning, execution, and ROI measurement system. From initial concept through post-event analysis — conferences, webinars, workshops, meetups, and more.

## Install

```bash
clawhub install afrexai-event-management
```

## What This Skill Does

Turns your AI agent into a full-service event manager:

- **12-phase event lifecycle** — strategy through post-event optimization
- **Event Brief YAML** with Go/No-Go scorecard
- **Budget templates** with sponsorship package design
- **Speaker management** with outreach templates and timelines
- **Marketing playbook** with email sequences for every phase
- **Day-of run sheet** with crisis management protocols
- **Webinar-specific playbook** with conversion benchmarks
- **Post-event ROI analysis** with content repurposing matrix
- **Hybrid/virtual event** production checklists
- **Quality rubric** (0-100) across 8 dimensions

## Quick Start

Tell your agent:
- "Plan a 200-person tech conference for May"
- "Create a webinar funnel for lead generation"
- "Build sponsor packages for our annual summit"
- "Write the marketing email sequence for our workshop"

## ⚡ Level Up

Want industry-specific event strategies? Check out our context packs:

- **SaaS Context Pack** — product launch events, user conferences, demo days
- **Professional Services Pack** — client summits, thought leadership events
- **Healthcare Context Pack** — medical conferences, CME events, compliance

**$47 each** → [Browse all packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify prospects
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — Complete B2B sales system
- [afrexai-presentation-mastery](https://clawhub.com/skills/afrexai-presentation-mastery) — Design and deliver presentations
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand identity and GTM
- [afrexai-community-growth-engine](https://clawhub.com/skills/afrexai-community-growth-engine) — Build and monetize communities

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
