# ESG & Sustainability Reporting Framework

Complete ESG reporting skill for OpenClaw agents. Covers environmental (carbon, water, waste), social (DEI, supply chain, community), and governance (board, ethics, transparency) metrics aligned with 2026 disclosure standards.

## What It Does

- **Materiality assessment** — double materiality (financial + impact) analysis
- **Carbon tracking** — Scope 1, 2, 3 emissions with SBTi-aligned reduction targets
- **Regulatory compliance** — CSRD, SEC Climate, ISSB, UK SDR, TCFD, GRI, CDP mapping
- **ESG scoring** — weighted 1-5 scoring across E/S/G with industry benchmarks
- **Report generation** — full report structure with data tables and YoY trends
- **Industry-specific guidance** — tailored priorities for 10 verticals

## Who It's For

- CFOs and sustainability officers preparing annual ESG reports
- Investors running ESG due diligence on portfolio companies
- Compliance teams mapping regulatory requirements (CSRD, SEC, ISSB)
- Board members needing ESG scorecards and risk dashboards
- Consultants building ESG programs for clients

## Standards Covered

| Standard | Status 2026 |
|----------|-------------|
| CSRD (EU) | Mandatory for large companies |
| SEC Climate Disclosure | Phased rollout |
| ISSB (IFRS S1/S2) | Adopted by 20+ jurisdictions |
| TCFD | Widely mandatory |
| GRI | Voluntary, expected by investors |
| CDP | Annual questionnaire |

## Quick Start

Install this skill in your OpenClaw agent, then ask:

- "Run an ESG materiality assessment for our company"
- "Generate a CSRD-compliant sustainability report"
- "Score our ESG performance and identify gaps"
- "Map our regulatory obligations across US, EU, and UK"
- "Calculate our carbon footprint across all 3 scopes"

## Part of the AfrexAI Business Context Pack Series

This is a free skill from AfrexAI. For deeper industry-specific context packs ($47 each):

- [Browse all 10 Context Packs](https://afrexai-cto.github.io/context-packs/)
- [Free AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)

**Bundle deals:** Pick 3 for $97 | All 10 for $197 | Everything Bundle $247
