# Engineering Manager OS ⚙️

The complete operating system for engineering managers — from first-time leads to directors scaling multiple teams.

Not generic management advice. This is the specific, actionable system that high-performing EMs run daily: 1:1 templates, performance calibration matrices, hiring scorecards, incident playbooks, architecture decision records, and org design frameworks.

## Install

```bash
clawhub install afrexai-engineering-manager
```

## What's Inside

- **Team Architecture** — topology assessment, health radar (8 dimensions), composition model
- **1:1 System** — YAML templates, 40+ question bank, flight risk detection, retention playbook
- **Performance Management** — calibration matrix, SBI-I feedback framework, PIP template, promotion case builder
- **Hiring Machine** — JD template, interview scorecards, debrief protocol, candidate closing framework
- **Technical Leadership** — ADR template, tech debt prioritization (Impact × Cost matrix), code review culture
- **Sprint & Delivery** — ceremony cheat sheet, health metrics, estimation heuristics
- **Incident Management** — response framework, blameless post-mortem template, on-call health guidelines
- **Scaling & Org Design** — team split signals and protocol, manager-to-IC ratios, IC-to-manager transition guide
- **Communication** — weekly status template, managing up checklist, stakeholder relationship map
- **Difficult Situations** — 5 complete playbooks (architecture disputes, high performer wants management, inherited low team, layoffs, best engineer quits)
- **100-point scoring rubric** across 7 dimensions

## Quick Start

```
"Run team health check" → Walk through all 8 radar dimensions
"Prepare 1:1 with Sarah" → Generate personalized agenda
"Write performance review for Alex" → Calibrate using the matrix
"Create job description for Senior Backend Engineer" → Full JD from template
```

## ⚡ Level Up

This skill gives you the frameworks. For industry-specific engineering management context:

- **[SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — SaaS-specific engineering org patterns, scaling playbooks, and platform team design
- **[Fintech Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — Compliance-heavy engineering management, regulated deployment patterns
- **[Healthcare Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — HIPAA-compliant engineering operations, clinical system ownership

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework
- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — Complete DevOps & platform engineering
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — API design lifecycle
- [afrexai-qa-testing-engine](https://clawhub.com/skills/afrexai-qa-testing-engine) — Full QA system
- [afrexai-technical-docs](https://clawhub.com/skills/afrexai-technical-docs) — Documentation system

**Browse all AfrexAI skills →** [clawhub.com](https://clawhub.com)
**Context Packs →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
