# Employee Onboarding Generator

Build a structured 90-day onboarding plan for any role. Covers pre-boarding, Day 1, Week 1, 30/60/90-day milestones, buddy assignments, and success metrics.

## What You Get

- **Pre-boarding checklist** — IT provisioning, workspace setup, welcome kit, paperwork
- **Day 1 agenda** — orientation schedule, first-day experience design
- **Week 1 plan** — team intros, tool walkthroughs, first quick win assignment
- **30/60/90 day milestones** — role-specific goals with clear success criteria
- **Buddy/mentor program** — matching framework, check-in cadence, escalation paths
- **Manager playbook** — weekly 1:1 templates, feedback frameworks, red flags to watch
- **Compliance tracking** — required training, policy acknowledgments, certification deadlines

## Usage

Tell the agent:
- Role title and department
- Team size and reporting structure
- Remote, hybrid, or in-office
- Industry (for compliance requirements)
- Any specific tools or systems they need access to

The agent generates a complete onboarding package: checklists, timelines, templates, and tracking sheets.

## Why This Matters

- 20% of employee turnover happens in the first 45 days
- Structured onboarding improves retention by 82% (Brandon Hall Group)
- New hires reach full productivity 34% faster with a formal program
- Companies lose $15,000-$25,000 per failed hire in the first year

## Onboarding Framework

### Pre-boarding (Offer Signed → Day 1)

**IT & Access:**
- [ ] Laptop/equipment ordered and configured
- [ ] Email account created
- [ ] Slack/Teams/chat tool access
- [ ] All role-specific SaaS tools provisioned
- [ ] VPN and security credentials
- [ ] Badge/building access

**HR & Admin:**
- [ ] Offer letter signed and filed
- [ ] Background check completed
- [ ] Tax forms (W-4/P45/equivalent) sent
- [ ] Benefits enrollment package sent
- [ ] Employee handbook acknowledgment
- [ ] Emergency contact form

**Welcome:**
- [ ] Welcome email from manager (personal, not template)
- [ ] Buddy/mentor assigned and introduced via email
- [ ] First week calendar pre-populated
- [ ] Team Slack channel introduction drafted

### Day 1

| Time | Activity | Owner |
|------|----------|-------|
| 9:00 | Welcome & workspace tour | Manager |
| 9:30 | IT setup verification | IT/Buddy |
| 10:00 | HR orientation (benefits, policies) | HR |
| 11:00 | Team introductions | Manager |
| 11:30 | Buddy coffee chat | Buddy |
| 12:00 | Team lunch | Team |
| 13:00 | Role overview & expectations | Manager |
| 14:00 | Tool walkthroughs | Buddy |
| 15:00 | First task assignment (quick win) | Manager |
| 16:00 | End-of-day check-in | Manager |

### Week 1

- Day 2-3: Deep dive into team processes, documentation, current projects
- Day 4: Shadow a senior team member through a typical workflow
- Day 5: Complete first deliverable (intentionally scoped small), Friday check-in with manager

### 30-Day Milestone
- Completed all required training and certifications
- Understands team workflows and can navigate tools independently
- Delivered 2-3 small contributions
- Built relationships with key cross-functional contacts
- Manager assessment: on track / needs support / concern

### 60-Day Milestone
- Owns a workstream or project independently
- Contributing to team meetings with informed opinions
- Identified one process improvement opportunity
- Received and incorporated first round of feedback
- Manager assessment: exceeding / on track / needs support

### 90-Day Milestone
- Fully productive in role (measured against job description KPIs)
- Completed probation review (if applicable)
- Has a development plan for next 6 months
- Net Promoter Score: "Would you recommend this company to a friend?"
- Manager assessment: strong performer / meeting expectations / performance plan

### Manager 1:1 Template (Weekly)

```
## Weekly Check-in — [Name] — Week [X]

### How are you feeling? (1-10)
### What went well this week?
### What's been confusing or frustrating?
### What do you need from me?
### Goals for next week:
### Any concerns? (theirs or yours)
```

### Red Flags (Escalate Immediately)
- No-show on Day 1 without communication
- Disengagement in first 2 weeks (camera off, monosyllabic, missing meetings)
- Buddy reports concerns about culture fit
- Required training not completed by Day 14
- Manager hasn't held a single 1:1 by Day 7

### Onboarding Success Metrics

| Metric | Target | Measurement |
|--------|--------|-------------|
| Time to first contribution | < 5 business days | Manager tracked |
| Time to full productivity | < 90 days | KPI-based |
| 90-day retention rate | > 95% | HR data |
| New hire satisfaction (survey) | > 4.2/5.0 | 30-day survey |
| Manager satisfaction | > 4.0/5.0 | 90-day survey |
| Training completion rate | 100% by Day 14 | LMS data |

## Output Formats

The agent can generate:
- **Google Sheets / Excel** — tracking template with conditional formatting
- **Notion database** — kanban board with phases as columns
- **Markdown checklist** — for GitHub/internal docs
- **Slack workflow** — automated reminders at each milestone
- **Email sequences** — pre-boarding drip campaign (5 emails over 2 weeks)
