# Email → Calendar Extraction Engine

**Turn emails into calendar events with zero missed deadlines.**

The most comprehensive email-to-calendar skill for OpenClaw. No external dependencies — works with any calendar provider.

## What It Does

- 📧 Extracts events, deadlines, action items, and travel logistics from any email
- 🎯 Confidence scoring (high/medium/low) so you know what's solid vs. vague
- ✈️ Special travel mode: flights, hotels, car rentals — all auto-extracted
- ⚠️ Deadline engine with smart reminder scheduling
- 🔄 Duplicate detection before creating events
- 📬 Batch inbox scanning with grouped results
- 🌍 Multi-timezone support with automatic conversion
- 📋 Works with Google Calendar, Apple Calendar, Outlook, Notion, or raw ICS export

## Install

```bash
clawhub install afrexai-email-to-calendar
```

## Quick Start

Forward an email to your agent, or ask it to scan your inbox:

> "Check my inbox for any events or deadlines this week"

> "Here's a travel confirmation — add everything to my calendar"

The agent will extract structured events, present them for review, and create calendar entries on confirmation.

## Why This One?

Most email-to-calendar skills only handle simple "meeting at 2pm" cases. This one handles:

- Multi-day conferences with multiple sessions
- Travel itineraries (flights + hotels + car rentals)
- Deadline detection with action URLs
- Rescheduled/cancelled event updates
- Date ambiguity resolution (MM/DD vs DD/MM)
- Recurring events with exceptions
- ICS attachment parsing

## ⚡ Level Up

Want full industry-specific agent context? Check out our premium packs:

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — Sales pipeline, meeting cadence, customer success workflows ($47)
- **[Professional Services Pack](https://afrexai-cto.github.io/context-packs/)** — Client scheduling, billable hours, project timelines ($47)

Each pack includes 5 deep-context files that make your agent an industry expert.

## 🔗 More Free Skills by AfrexAI

- `afrexai-humanizer` — Remove AI-speak from any content
- `afrexai-prospect-researcher` — Deep company & contact research
- `afrexai-email-triager` — Smart inbox triage and prioritization
- `afrexai-meeting-prep` — Pre-meeting research and briefing docs
- `afrexai-weekly-review` — Automated weekly progress summaries

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
