# Email Marketing Engine

Complete email marketing system for AI agents — deliverability, list building, sequences, cold outreach, automation, analytics, and revenue optimization.

**Zero dependencies. No API keys. Works with any ESP.**

## Install

```bash
clawhub install afrexai-email-marketing-engine
```

## What's Inside

- **Domain authentication** — SPF/DKIM/DMARC setup checklist with DNS records
- **Warm-up schedule** — 6-week plan to build sender reputation from scratch
- **7-email welcome sequence** — Complete templates with timing and goals
- **5-email cold outreach sequence** — Research-backed, personalized templates
- **Segmentation architecture** — Lifecycle + behavioral + demographic segments
- **A/B testing protocol** — Statistical methodology with test log template
- **Subject line scoring** — 10-point rubric to rate before sending
- **Email copy scoring** — 100-point quality rubric
- **Automation map** — 8 trigger-based workflows (trial, cart, churn, NPS, etc.)
- **Cold email deliverability** — Separate domain strategy, volume rules, reply handling
- **Revenue attribution** — 4 models with ROI calculation
- **Compliance** — CAN-SPAM, GDPR, CASL checklists with penalties
- **Weekly review template** — Dashboard for tracking growth, engagement, health, revenue

## Quick Start

```
"Build a welcome sequence for my SaaS product"
"Write a cold email for the VP of Sales at Stripe"
"Score this subject line: 5 mistakes killing your pipeline"
"Audit my email list health"
"Set up email authentication for mydomain.com"
```

## ⚡ Level Up

This skill gives you the methodology. Want the full industry playbook?

**[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 each, with complete market landscapes, competitor analysis, compliance frameworks, and implementation guides for your specific vertical.

- **SaaS Pack** — SaaS-specific email sequences, churn prevention, PLG funnels
- **Professional Services Pack** — Client nurture sequences, proposal follow-ups
- **Ecommerce Pack** — Cart recovery, post-purchase flows, seasonal campaigns
- **Recruitment Pack** — Candidate outreach, employer branding, talent nurture

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify leads
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content at scale
- [afrexai-social-media-engine](https://clawhub.com/skills/afrexai-social-media-engine) — Multi-platform social strategy
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Win more deals
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — Support & retention system

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
