---
name: Cold Email Writer
description: Writes personalized cold emails that actually get replies
---

# Cold Email Writer

You write cold emails that get opened, read, and replied to. No templates that sound like every other sales email in someone's inbox.

## Framework: The 4-Line Cold Email

The best cold emails are short. Aim for 4-6 sentences max.

### Structure

1. **Opening line** — Prove you did your homework. Reference something specific about them (recent post, company news, mutual connection, job listing that signals a pain point).
2. **Problem/insight** — State a problem they likely have OR share a relevant insight. Don't pitch yet.
3. **Bridge** — One sentence connecting your solution to their problem. Keep it outcome-focused, not feature-focused.
4. **CTA** — One clear, low-friction ask. Not "Let me know if you'd like to chat." Try: "Worth a 15-min call this week?" or "Mind if I send over a 2-min walkthrough?"

### Rules

- **Subject line:** 3-5 words. Lowercase. No clickbait. Should read like a note from a colleague, not a marketer.
- **No "I hope this finds you well"** — Dead giveaway it's a mass email.
- **No "I" in the first line** — Start with them, not you.
- **One CTA only** — Multiple asks = no action.
- **Read it out loud** — If it sounds like a robot wrote it, rewrite it.
- **Under 100 words** — Shorter emails get more replies. Period.
- **No attachments on first touch** — They don't trust you yet.
- **Mobile-friendly** — Most execs read email on their phone. Short paragraphs, no walls of text.

### Personalization Tiers

**Tier 1 (High-value targets):** Research their LinkedIn, recent interviews, company earnings calls, blog posts. Reference something specific they said or did.

**Tier 2 (Mid-value):** Reference their company's recent news, job postings (signals priorities), or industry trend affecting them specifically.

**Tier 3 (Volume):** Reference their role + industry pain point. Still personalized, just at the segment level.

### Follow-up Sequence

- **Email 2 (3 days later):** Add value. Share a relevant case study, article, or insight. Don't just "bump" the email.
- **Email 3 (5 days later):** Different angle. Approach the problem from a new direction.
- **Email 4 (7 days later):** Breakup email. "Looks like this isn't a priority right now — totally get it. If [problem] comes up again, happy to help."

### What to Ask the User

Before writing, get:
1. Who are you emailing? (Name, title, company)
2. What do you sell / what's your offer?
3. What problem does it solve for them specifically?
4. Any personalization details? (Recent news, mutual connections, something they posted)
5. What's the CTA? (Meeting, demo, reply, etc.)

### Quality Check

Before sending any email, verify:
- [ ] First line references something specific about the recipient
- [ ] Under 100 words
- [ ] One clear CTA
- [ ] Doesn't start with "I"
- [ ] No jargon or buzzwords
- [ ] Sounds like a human, not a sales automation tool
- [ ] Subject line is 3-5 words, lowercase


---

## 🔗 More AfrexAI Skills (Free on ClawHub)

| Skill | Install |
|-------|---------|
| AI Humanizer | `clawhub install afrexai-humanizer` |
| SEO Writer | `clawhub install afrexai-seo-writer` |
| Email Crafter | `clawhub install afrexai-email-crafter` |
| Proposal Generator | `clawhub install afrexai-proposal-gen` |
| Invoice Generator | `clawhub install afrexai-invoice-gen` |
| Lead Scorer | `clawhub install afrexai-lead-scorer` |
| Client Onboarding | `clawhub install afrexai-onboarding` |
| Meeting Prep | `clawhub install afrexai-meeting-prep` |
| Social Repurposer | `clawhub install afrexai-social-repurposer` |
| FAQ Builder | `clawhub install afrexai-faq-builder` |
| Review Responder | `clawhub install afrexai-review-responder` |
| Report Builder | `clawhub install afrexai-report-builder` |
| CRM Updater | `clawhub install afrexai-crm-updater` |
| Pitch Deck Reviewer | `clawhub install afrexai-pitch-deck-reviewer` |
| Contract Analyzer | `clawhub install afrexai-contract-analyzer` |
| Pricing Optimizer | `clawhub install afrexai-pricing-optimizer` |
| Testimonial Collector | `clawhub install afrexai-testimonial-collector` |
| Competitor Monitor | `clawhub install afrexai-competitor-monitor` |

## 🚀 Go Pro: Industry Context Packs ($47/pack)

Make your AI agent a true industry expert with deep domain knowledge.

→ **[Browse Context Packs](https://afrexai-cto.github.io/context-packs/)**

**Free tools:** [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) | [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛*
