# Django Production Engineering 🐍

The complete Django production methodology — from project architecture to deployment. Not another tutorial. A battle-tested operating system for building, scaling, and shipping production Django applications.

## What's Inside

- **12-phase production system** — architecture → ORM mastery → DRF → auth → migrations → caching → Celery → testing → performance → deployment → patterns → Django 5.x
- **8-signal health check** — score any Django project in 60 seconds
- **ORM deep dive** — N+1 prevention, bulk operations, F() expressions, index strategy, QuerySet evaluation rules
- **DRF best practices** — service layer pattern, separate read/write serializers, cursor pagination
- **Zero-downtime migrations** — 3-step nullable pattern, safety rules, conflict resolution
- **Production Celery** — retry with backoff, time limits, idempotent tasks, queue separation
- **Security hardening** — 10-point checklist, JWT setup, RBAC permissions, CSP headers
- **Testing strategy** — pytest-django, factories, service testing, CI coverage enforcement
- **Deployment** — multi-stage Dockerfile, Gunicorn config, GitHub Actions CI/CD, production checklist
- **100-point quality rubric** across 8 dimensions
- **10 common mistakes** with fixes
- **Django 5.x features** — GeneratedField, db_default, field groups

## Install

```bash
clawhub install afrexai-django-production
```

## Quick Start

Ask your agent:
- "Review this Django project" — instant /8 health score
- "Optimize these queries" — N+1 fixes + index recommendations
- "Set up DRF for this model" — full serializer + view + URL + test generation
- "Production checklist" — P0/P1 audit with specific fixes

## ⚡ Level Up

Take your Django backend to the next level with an **AfrexAI Context Pack** ($47) — deep industry context for AI agents building production systems:

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — multi-tenancy, billing, onboarding flows
- **[Fintech Context Pack](https://afrexai-cto.github.io/context-packs/)** — compliance, transaction processing, audit trails
- **[Healthcare Context Pack](https://afrexai-cto.github.io/context-packs/)** — HIPAA, patient data, HL7/FHIR

## 🔗 More Free Skills by AfrexAI

- `afrexai-fastapi-production` — FastAPI production engineering
- `afrexai-python-production` — Python production patterns
- `afrexai-api-architecture` — API design methodology
- `afrexai-database-engineer` — Database engineering
- `afrexai-devops-engine` — CI/CD & DevOps

**Browse all skills →** [AfrexAI on ClawHub](https://clawhub.com)
**Context Packs →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
