# IT Disaster Recovery Plan Generator

Generate production-ready disaster recovery plans with RTO/RPO targets, failover runbooks, backup strategies, and compliance mapping.

## Why This Exists

Most DR plans are 50-page PDFs that nobody reads until something breaks. This skill generates actionable, testable recovery procedures your team can actually follow at 3 AM.

**The math:** Average downtime costs $5,600/minute. A single 4-hour outage without DR = $1.3M. A proper DR plan costs $15K-$50K/year to maintain. The ROI writes itself.

## What You Get

- **Risk assessment matrix** with scored threats and mitigations
- **Service tier classification** (critical → standard) with RTO targets
- **Step-by-step failover runbooks** with CLI commands and time estimates
- **Backup strategy** following the 3-2-1 rule
- **Communication templates** for P1-P4 incidents
- **Testing schedule** (tabletop → full simulation)
- **Cost model** benchmarked against industry data
- **Compliance mapping** to SOC 2, ISO 27001, HIPAA, PCI DSS

## Quick Start

```
Generate a DR plan for [your stack]. Primary region: [region]. RTO: [target]. RPO: [target]. Team: [size].
```

## Built by AfrexAI

We build AI agent tools for operations teams that can't afford downtime.

- [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific agent knowledge ($47/pack)
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money to manual work
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your AI agent stack in 5 minutes
