# DevRel & Developer Advocacy Engine 🛠️

> The complete developer relations operating system — from DX audit to community building to business attribution. Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/).

## What This Skill Does

Turns your AI agent into a DevRel strategist that can:

- **Audit developer experience** — Score your DX across 6 dimensions with actionable fixes
- **Build content engines** — Technical blog templates, pillar architecture, SEO for developers
- **Grow communities** — Platform selection, engagement playbooks, ambassador programs
- **Plan events** — Conference talks, hackathons, workshops, office hours
- **Design SDK strategy** — Language priority matrix, design principles, ecosystem planning
- **Measure everything** — 5-layer metrics framework with business attribution
- **Scale teams** — Hiring priority, OKRs, role definitions

## Install

```bash
clawhub install afrexai-devrel-engine
```

## Quick Start

```
"Audit our developer experience for [product]"
"Create a DevRel strategy for our API product targeting Python developers"
"Design an ambassador program for our open source project"
"Set up DevRel metrics dashboard"
```

## What's Inside

- **12-phase system** covering the full DevRel lifecycle
- **DX scoring rubric** (0-100) with quick win checklist
- **Content pillar architecture** with blog post templates
- **Community health dashboard** YAML with engagement playbook
- **Ambassador program** design with 3 tiers and anti-gaming rules
- **Conference talk proposal** template
- **Hackathon design** framework with judging criteria
- **SDK priority matrix** by language with design principles
- **Developer marketing funnel** with channel effectiveness matrix
- **5-layer metrics framework** with attribution model
- **Open source strategy** — governance, licensing, contributor funnel
- **Team structure** with hiring priority by stage
- **DevRel quality rubric** (0-100) across 8 dimensions

## ⚡ Level Up

Want the complete context for your vertical?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** give your AI agent deep industry knowledge:

- 🖥️ **SaaS Context Pack** — Perfect for developer-focused SaaS companies
- 💰 **Fintech Context Pack** — For developer tools in financial services
- 🏥 **Healthcare Context Pack** — For health tech developer platforms

## 🔗 More Free Skills by AfrexAI

- [afrexai-agent-engineering](https://clawhub.com/skills/afrexai-agent-engineering) — Build & orchestrate AI agents
- [afrexai-community-growth-engine](https://clawhub.com/skills/afrexai-community-growth-engine) — Community building & monetization
- [afrexai-technical-docs](https://clawhub.com/skills/afrexai-technical-docs) — Documentation systems
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — API design & lifecycle
- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — Product requirements

---

Built with 🖤💛 by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
