# Debt Collection & Recovery Playbook

Generate compliant debt recovery strategies, collection letter sequences, and payment plan frameworks.

## What This Does
- Creates FDCPA/FCA-compliant collection letter sequences (initial notice → escalation → final demand)
- Builds payment plan calculators with interest modeling
- Generates aging bucket analysis with priority scoring
- Produces skip tracing checklists and debtor communication scripts
- Maps state-by-state statute of limitations
- Creates bad debt write-off decision frameworks

## How To Use

Tell the agent what you need:
- "Generate a 5-letter collection sequence for B2B invoices"
- "Build a payment plan for $47,000 over 12 months at 8% APR"
- "Create an aging analysis for our receivables"
- "What's the statute of limitations for debt in California?"

## Collection Letter Sequence

### Letter 1 — Friendly Reminder (Day 1-7 past due)
Subject: Invoice [#] — Payment Reminder

Quick note — invoice [#] for [amount] was due on [date]. Sometimes things slip through. If already sent, disregard.

Payment options: [link/details]

### Letter 2 — Firm Follow-Up (Day 15-21)
Subject: Invoice [#] — Second Notice

Following up on invoice [#] for [amount], now [X] days past due. Please arrange payment by [date] to avoid late fees per our agreement.

### Letter 3 — Escalation Notice (Day 30-45)
Subject: Invoice [#] — Action Required

Invoice [#] for [amount] is now [X] days overdue. Per our terms, a [X]% late fee of [amount] has been applied. Total now due: [amount].

If we don't receive payment by [date], we'll need to escalate this matter.

### Letter 4 — Pre-Collection (Day 60)
Subject: Invoice [#] — Final Notice Before Collection Action

This is formal notice that invoice [#] totaling [amount] remains unpaid after [X] days. Without payment by [date], this account will be referred to our collection partner.

This may affect your business credit rating.

### Letter 5 — Final Demand (Day 75-90)
Subject: Invoice [#] — Final Demand

Final notice. Invoice [#] for [amount] will be referred to [collection agency/legal counsel] on [date] if not resolved. Contact us immediately to discuss resolution options.

## Aging Bucket Analysis

| Bucket | Days | Priority | Action | Expected Recovery |
|--------|------|----------|--------|-------------------|
| Current | 0-30 | Low | Auto-reminder | 95-98% |
| 31-60 | 31-60 | Medium | Phone + email | 85-90% |
| 61-90 | 61-90 | High | Escalation letter | 70-75% |
| 91-120 | 91-120 | Critical | Collection agency | 40-50% |
| 120+ | 120+ | Write-off review | Legal/write-off | 15-25% |

## Priority Score Formula
Score = (Amount × 0.4) + (Days Overdue × 0.3) + (Customer Value × 0.2) + (Payment History × 0.1)

- Score > 80: Immediate personal outreach
- Score 50-80: Escalation sequence
- Score < 50: Standard auto-sequence

## Payment Plan Framework

For debts over $5,000, offer structured plans:

| Plan | Duration | Interest | Min Payment | Best For |
|------|----------|----------|-------------|----------|
| Quick | 3 months | 0% | 33% of balance | Good-faith debtors |
| Standard | 6 months | 5% APR | ~17% + interest | Mid-range balances |
| Extended | 12 months | 8% APR | ~9% + interest | Large balances |
| Hardship | 18 months | 0% | Negotiated | Proven inability to pay |

## FDCPA Compliance Checklist (US)
- [ ] Initial validation notice sent within 5 days of first contact
- [ ] Debtor's right to dispute within 30 days clearly stated
- [ ] No contact before 8 AM or after 9 PM local time
- [ ] No contact at workplace if debtor objects
- [ ] No threats of actions you can't/won't take
- [ ] No misrepresentation of amount owed
- [ ] No harassment, oppression, or abuse
- [ ] Cease communication upon written request (except legal notices)
- [ ] Mini-Miranda warning included in all communications

## Statute of Limitations by State (Top 10)
| State | Written Contract | Oral Contract | Open Account |
|-------|-----------------|---------------|--------------|
| California | 4 years | 2 years | 4 years |
| New York | 6 years | 6 years | 6 years |
| Texas | 4 years | 4 years | 4 years |
| Florida | 5 years | 4 years | 4 years |
| Illinois | 10 years | 5 years | 5 years |
| Pennsylvania | 4 years | 4 years | 4 years |
| Ohio | 8 years | 6 years | 6 years |
| Georgia | 6 years | 4 years | 4 years |
| Michigan | 6 years | 6 years | 6 years |
| North Carolina | 3 years | 3 years | 3 years |

## Bad Debt Write-Off Decision

Write off when ALL of these are true:
1. Account is 180+ days past due
2. All collection attempts exhausted (minimum 5 contacts)
3. Skip tracing returned no viable contact
4. Amount is below legal action threshold (typically < $5,000)
5. Cost of recovery exceeds expected recovery amount

## ROI of Professional Collections
- In-house collection cost: $15-25 per account
- Agency contingency: 25-50% of recovered amount
- Legal action: $500-2,000 per case + court fees
- Break-even: Agency makes sense when balance > $1,000 and account is 90+ days

---

## Take It Further

This skill gives you the collection framework. For full industry-specific automation — including AI-powered payment reminders, predictive churn scoring, and automated escalation workflows:

- **[AI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47/pack, 10 industries covered
- **[AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find where you're losing money
- **[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)** — Deploy your first AI agent in 15 minutes

### Bundle Deals
- Pick 3 Packs — $97 (save $44)
- All 10 Packs — $197 (save $273)
- Everything Bundle — $247 (all packs + playbook + setup wizard)
