# Davis-Bacon & Prevailing Wage Compliance

Federal construction compliance agent. Covers Davis-Bacon Act, Related Acts, state prevailing wage laws, and DOL Wage Determinations.

## When to Use
- Bidding on federal or federally-assisted construction projects
- Determining prevailing wage rates for a project
- Certified payroll preparation and submission
- DOL compliance reviews or investigations
- State prevailing wage ("little Davis-Bacon") requirements
- Apprenticeship program compliance on federal jobs

## Capabilities

### Wage Determination Lookup
Help contractors find the correct DOL Wage Determination (WD) for their project:

| Factor | Details |
|--------|---------|
| **WD Types** | General (heavy, highway, building, residential) vs Project-specific |
| **Geographic scope** | County-level rates — must match project location exactly |
| **Modification tracking** | WDs updated weekly; locked 10 days before bid opening |
| **Rate components** | Basic hourly rate + fringe benefits = total prevailing wage |
| **SAM.gov lookup** | All WDs published at sam.gov/wage-determinations |

### Covered Projects

| Threshold | Requirement |
|-----------|-------------|
| **Davis-Bacon Act** | Direct federal contracts >$2,000 for construction/repair/alteration |
| **Related Acts** | ~60 federal statutes (CDBG, FHWA, FAA, HUD, EPA SRF, WIFIA, IIJA, IRA) |
| **IIJA (2021)** | Infrastructure Investment and Jobs Act — $550B+ in new spending, all DB-covered |
| **IRA (2022)** | Inflation Reduction Act — clean energy projects require prevailing wage for full tax credits |
| **State laws** | 28 states + DC have prevailing wage laws (varying thresholds $1K-$250K) |

### Certified Payroll Requirements

Weekly certified payroll (WH-347) must include:

| Field | Requirement |
|-------|-------------|
| **Employee info** | Name, address, last 4 SSN, work classification |
| **Hours** | Daily and weekly hours, straight time and overtime |
| **Rate** | Hourly rate + fringe breakdown (cash or bona fide plan) |
| **Deductions** | Itemized, only permissible deductions (29 CFR 3) |
| **Certification** | Signed Statement of Compliance (weekly) |
| **Submission** | Weekly to contracting agency — retained 3 years minimum |
| **Electronic** | LCPtracker, Elation Systems, B2Gnow accepted by most agencies |

### Classification & Wage Conformance

When a needed classification doesn't appear on the WD:

1. **Check existing classifications** — often a similar one covers the work
2. **Request conformance** — submit SF-1444 to contracting officer
3. **CO forwards to DOL** — Wage and Hour Division reviews within 30 days
4. **Interim rate** — pay proposed rate pending DOL determination
5. **No self-classification** — contractor cannot unilaterally assign rates

### Common Violations & Penalties

| Violation | Penalty Range |
|-----------|---------------|
| **Underpayment** | Back wages + interest (liquidated damages = 100% of underpayment) |
| **Falsified certified payroll** | Criminal: up to $10,000 fine + 10 years imprisonment (18 USC 1001) |
| **Kickbacks** | Criminal: up to $5,000 fine + 5 years imprisonment per occurrence |
| **Debarment** | 3-year ban from ALL federal contracts (company + individuals) |
| **Cross-debarment** | Federal debarment recognized by most states |
| **Willful violations** | DOL refers to DOJ for criminal prosecution |
| **Subcontractor liability** | Prime contractor jointly liable for sub violations |

### Fringe Benefits Compliance

| Method | Requirements |
|--------|-------------|
| **Bona fide plan** | Irrevocable contributions to health, pension, vacation, apprenticeship funds |
| **Cash equivalent** | Pay fringe amount as cash wages (added to base rate) |
| **Combination** | Partial plan + partial cash — must total full fringe rate |
| **Annualization** | Cannot credit plan costs for non-covered work |
| **Documentation** | Maintain plan documents, contribution records, benefit statements |

### Apprenticeship Requirements

| Requirement | Details |
|-------------|---------|
| **Registration** | Must be registered with DOL/BAT or recognized SAA |
| **Ratio** | Cannot exceed approved apprentice-to-journeyworker ratio |
| **Rate** | Percentage of journeyworker rate per registered program schedule |
| **Supervision** | Must work under journeyworker on-site |
| **Non-registered** | Laborer or mechanic rate required — no apprentice discount |
| **IIJA/IRA bonus** | Some programs require apprenticeship utilization for full funding |

### State Prevailing Wage Quick Reference

| State | Threshold | Key Differences from Federal |
|-------|-----------|------------------------------|
| **California** | $1,000 (public works) | DIR registration required, electronic CPR, steep penalties |
| **New York** | $0 (all public work) | Fiscal officer determines rates, broader coverage |
| **Illinois** | $0 (all public work) | Separate rates by county, monthly reporting |
| **Massachusetts** | $0 (all public work) | Weekly payroll + monthly certified statements |
| **New Jersey** | $2,000 | Registration Act compliance, stop-work authority |
| **Ohio** | $250,000 | Covers new construction only (not repair/maintenance) |
| **Pennsylvania** | $25,000 | Separate determination process from federal |
| **Washington** | $0 (all public work) | Intent/affidavit filing before work begins |

### Investigation & Audit Preparation

**Pre-audit checklist:**
- [ ] All WH-347 certified payrolls filed weekly
- [ ] Wage determination posted at job site (physical or electronic)
- [ ] Employee interviews match payroll records
- [ ] Fringe benefit contributions documented and current
- [ ] Apprentice registrations on file
- [ ] Subcontractor payrolls collected and reviewed
- [ ] Time records match daily logs/sign-in sheets
- [ ] No split classifications without documentation
- [ ] Overtime calculated correctly (40-hour week, per FLSA)
- [ ] All required posters displayed (WH-1321 "Employee Rights")

### IRA Prevailing Wage & Apprenticeship (Clean Energy)

For Inflation Reduction Act tax credit projects:

| Credit | Base | With PW&A | Multiplier |
|--------|------|-----------|------------|
| **ITC (Solar/Wind)** | 6% | 30% | 5x |
| **PTC (Wind/Other)** | 0.3¢/kWh | 1.5¢/kWh | 5x |
| **45X Manufacturing** | Base amount | 3x base | 3x |
| **45V Hydrogen** | $0.12-0.60/kg | $0.60-3.00/kg | 5x |

**Requirements:** Pay prevailing wages during construction AND for 5 years after placed in service. Apprenticeship hours = 12.5% (2024), 15% (2025+). Correction/penalty framework for good-faith failures.

## Output Format
- Rate lookups: classification, base rate, fringe, total, WD number, expiration
- Compliance reviews: checklist with pass/fail + corrective action
- Risk assessments: violation exposure in dollars + probability
- Bid preparation: wage cost worksheets by classification and hours

## Integration
Works with: contract review, construction project management, payroll systems, bid estimation tools.

---

**Need help building compliant payroll systems or automating Davis-Bacon tracking?**
Browse our full toolkit: https://afrexai-cto.github.io/context-packs/

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI tools for businesses that actually work.
