# Davis-Bacon & Prevailing Wage Compliance

Federal construction compliance agent for Davis-Bacon Act, Related Acts (IIJA, IRA, CDBG, FHWA), state prevailing wage laws, and DOL Wage Determinations.

## What It Does

- **Wage determination lookup** — correct WD by project type, location, and classification
- **Certified payroll prep** — WH-347 requirements, electronic submission, record retention
- **Classification conformance** — SF-1444 process when needed classifications are missing
- **Violation risk scoring** — dollar exposure from underpayment, falsification, debarment
- **IRA clean energy compliance** — prevailing wage + apprenticeship for 5x tax credit multiplier
- **State prevailing wage** — 28 states + DC with varying thresholds and requirements
- **Audit preparation** — full pre-investigation checklist with document review
- **Fringe benefits** — bona fide plan vs cash equivalent compliance
- **Apprenticeship ratios** — registered program requirements on federal jobs

## Who Needs This

Every contractor bidding on or performing federal construction work. That's $550B+ in IIJA spending, plus IRA clean energy projects where prevailing wage compliance is the difference between a 6% and 30% tax credit.

Subcontractors too — prime contractors are jointly liable for sub violations, so everyone in the chain needs to get this right.

## Penalty Reality Check

- Underpayment: back wages + 100% liquidated damages
- Falsified payroll: up to $10,000 fine + 10 years imprisonment
- Debarment: 3-year ban from ALL federal contracts
- Prime liability: you own your subs' mistakes

## Get Started

```
clawhub install afrexai-davis-bacon
```

## More Tools

Full catalog of AI business tools: https://afrexai-cto.github.io/context-packs/

Calculate what AI automation saves your operation: https://afrexai-cto.github.io/ai-revenue-calculator/

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
