# Database Engineering Mastery

Complete database design, optimization, migration, and operations system for AI agents. Covers PostgreSQL, MySQL, and SQLite — from schema design to production monitoring.

## Install

```bash
clawhub install afrexai-database-engineer
```

## What You Get

- **Schema Design** — Normalization framework, naming conventions, column type decision tree, relationship patterns, table templates
- **Indexing Strategy** — Index type selection guide (B-tree, GIN, GiST, BRIN, partial, covering), unused/missing index detection
- **Query Optimization** — EXPLAIN interpretation, 6 anti-pattern fixes, window functions, CTE patterns, keyset pagination
- **Migration Safety** — Zero-downtime patterns, batched backfills, concurrent index creation, rollback templates
- **Performance Monitoring** — Connection tracking, cache hit ratio, bloat detection, slow query analysis, lock monitoring
- **Backup & Recovery** — Strategy decision matrix, verification checklist, restore procedures
- **Security** — Least privilege roles, Row-Level Security, SQL injection prevention, audit triggers
- **PostgreSQL Tuning** — Configuration by server size, connection pooling (PgBouncer)
- **Common Patterns** — Soft delete, optimistic locking, event sourcing, time-series partitioning, full-text search, JSONB
- **Operational Runbooks** — Emergency procedures for overload and disk full, weekly maintenance checklist
- **100-point quality scoring** across 7 dimensions

## Quick Start

Tell your agent:
- "Design a schema for an e-commerce platform"
- "Optimize this query: SELECT * FROM orders WHERE..."
- "Audit this database for performance issues"
- "Write a safe migration to add a column"

## ⚡ Level Up

Get the complete **SaaS Context Pack** ($47) — includes database patterns plus full SaaS architecture, billing, auth, and scaling strategies.

👉 [Browse all context packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — SPEAR code review framework
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — Complete API lifecycle
- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — CI/CD, IaC, monitoring
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE analysis framework
- [afrexai-qa-testing-engine](https://clawhub.com/skills/afrexai-qa-testing-engine) — Full QA system

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
