# Data Room Builder

Generate a complete virtual data room structure, document checklist, and gap analysis for fundraising or M&A — in minutes, not weeks.

## What You Get
- Full folder hierarchy tailored to your stage and round type
- Prioritized document checklist (must-have / should-have / nice-to-have)
- Gap analysis with urgency flags and estimated prep time
- Access control recommendations (pre-NDA vs post-NDA vs management-only)

## Use Cases
- **Fundraising**: Seed to Series C+ — know exactly what investors expect before they ask
- **M&A**: Buyer-side or seller-side due diligence prep
- **Board governance**: Keep your house in order between rounds
- **Acqui-hire**: Lighter-weight checklist for team-focused deals

## Install
```
clawhub install afrexai-data-room
```

## Quick Start
Tell your agent:
> "Build a data room checklist for a Series A SaaS raise. We have 18 months of revenue, 12 employees, US-based."

---

**Running a SaaS company?** The [AfrexAI SaaS Context Pack](https://afrexai-cto.github.io/context-packs/) ($47) gives your AI agent deep knowledge of SaaS metrics, fundraising, churn analysis, and growth ops — so it works like a fractional COO.

**Find your biggest efficiency gaps first** → [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) (free, 2 minutes).
