# AfrexAI Data Privacy & Protection Program 🔐

The most comprehensive data privacy skill on ClawHub. Build, operate, and mature a privacy program that complies with **GDPR, CCPA/CPRA, LGPD, PIPEDA, POPIA** and more — while enabling business growth.

## What This Does

Turns your AI agent into a **Data Protection Officer (DPO)** that can:

- 🔍 **Assess** privacy program maturity (8-dimension scoring)
- 📋 **Build** Records of Processing Activities (ROPA) with YAML templates
- ⚖️ **Navigate** multi-regulation compliance (GDPR, CCPA, LGPD, PIPEDA, POPIA, APPI, PDPA)
- 📜 **Audit** privacy notices against legal requirements
- 🙋 **Manage** Data Subject Access Requests (DSARs) with response templates
- 🔎 **Conduct** Data Protection Impact Assessments (DPIAs)
- 🤝 **Evaluate** vendors with 100-point privacy scorecards
- 🚨 **Respond** to data breaches with step-by-step playbooks
- 🏗️ **Embed** Privacy by Design into product development
- 📊 **Track** program health with metrics dashboards

## Install

```bash
clawhub install afrexai-data-privacy
```

## Quick Start

```
"Assess our privacy program"
→ 8-dimension maturity assessment with scoring

"Which regulations apply to our SaaS company with EU customers?"
→ Applicability matrix with specific requirements

"We had a data breach"
→ Immediate response playbook with notification timelines

"Assess this vendor for privacy risk"
→ 100-point vendor privacy scorecard
```

## What's Inside

- **12 phases** from assessment to continuous improvement
- **ROPA template** with every GDPR Article 30 required field
- **8-regulation comparison matrix** (GDPR, CCPA, LGPD, PIPEDA, POPIA, APPI, PDPA, UK GDPR)
- **DSAR workflow** with response templates and rights-by-regulation table
- **DPIA template** with trigger checklist and risk assessment YAML
- **DPA checklist** with 14 essential clauses and red flags
- **Breach response playbook** with 4-phase timeline and notification templates
- **Consent management** framework with cookie tier implementation
- **Privacy by Design** engineering checklist (per feature/product)
- **10 Privacy-Enhancing Technologies** comparison
- **Vendor assessment scorecard** (0-100)
- **100-point program scoring rubric** across 8 weighted dimensions
- **Annual privacy calendar** with month-by-month activities
- **Training program design** by audience role
- **12 natural language commands**
- Zero dependencies

## ⚡ Level Up

This free skill gives you the complete methodology. For **industry-specific privacy implementations** with regulatory deep-dives, check out our context packs:

- 🏥 [Healthcare AI Context Pack](https://afrexai-cto.github.io/context-packs/) — HIPAA privacy rule deep-dive
- 💰 [Fintech AI Context Pack](https://afrexai-cto.github.io/context-packs/) — Financial data protection (GLBA, PCI DSS)
- ⚖️ [Legal AI Context Pack](https://afrexai-cto.github.io/context-packs/) — Attorney-client privilege, legal data handling
- 💻 [SaaS AI Context Pack](https://afrexai-cto.github.io/context-packs/) — SaaS data processing, SOC 2 privacy

**$47 per pack** — [Browse all 10 packs →](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-compliance-engine](https://clawhub.com/skills/afrexai-compliance-engine) — SOC 2, ISO 27001, GDPR, HIPAA compliance
- [afrexai-cybersecurity-engine](https://clawhub.com/skills/afrexai-cybersecurity-engine) — OWASP, incident response, security architecture
- [afrexai-risk-management](https://clawhub.com/skills/afrexai-risk-management) — Enterprise risk management system
- [afrexai-contract-review](https://clawhub.com/skills/afrexai-contract-review) — Contract analysis with CLAWS risk scoring
- [afrexai-ai-governance](https://clawhub.com/skills/afrexai-ai-governance) — EU AI Act, NIST AI RMF, responsible AI

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛 — AI agents that compound capital and code.*
