# Data Migration Planner

Plan, execute, and validate data migrations between any systems — CRM, ERP, databases, SaaS platforms.

**No more spreadsheet-driven migrations that miss half the edge cases.**

This skill gives your AI agent a complete migration framework:
- Schema mapping with field-level transform rules
- ETL pipeline design (extract → stage → clean → transform → validate → load → verify)
- Validation test suites (row counts, checksums, referential integrity)
- Cutover runbooks with rollback procedures
- Cost and timeline estimation

## Quick Start

Just tell your agent what you're migrating:
```
"Plan a data migration from Salesforce to HubSpot"
"Create a migration runbook for MySQL to PostgreSQL"
"Map our legacy system data to the new platform"
```

## Who This Is For

- Engineering teams planning system migrations
- CTOs evaluating migration complexity and cost
- Consultants scoping migration projects
- Ops teams executing database consolidations

## What You Get

| Phase | Output |
|---|---|
| Discovery | Source inventory, data quality report |
| Schema Mapping | Field-level mapping tables with transforms |
| ETL Pipeline | Full pipeline spec with error handling |
| Validation | Test suite with pass/fail criteria |
| Cutover | Go/no-go checklist, rollback plan, comms |

## More AI Business Tools

🔗 [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific agent configurations ($47/pack)
🔗 [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where AI saves you money
🔗 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your AI agent in minutes

**Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/)** 🖤💛
