# AfrexAI Data Engineering Command Center

Turn your AI agent into a senior data engineer. Complete methodology for designing, building, and operating production data pipelines — no code dependencies, no API keys, pure knowledge.

## Install

```bash
clawhub install afrexai-data-engineering
```

## What You Get

- **Architecture decision frameworks** — batch vs streaming vs lakehouse vs data mesh
- **Technology selection guides** — Airflow, dbt, Spark, Flink, Snowflake, BigQuery, and more
- **Data modeling methodology** — Kimball, Data Vault, OBT with SCD type guides
- **Pipeline design patterns** — extraction strategies, load patterns, idempotency rules
- **Data quality framework** — 6-dimension quality checks, data contracts, severity levels
- **Performance optimization** — SQL tuning, Spark optimization, partitioning strategies
- **Data governance** — classification, PII handling, catalog templates, lineage
- **Monitoring & alerting** — dashboard template, structured logging, alert routing
- **Testing strategy** — full test pyramid from unit to E2E
- **Cost optimization** — cloud cost reduction, ROI tracking, red flags
- **Operational runbooks** — failure triage, schema change management, disaster recovery
- **Advanced patterns** — CDC, feature stores, SCD Type 2 SQL, data mesh

## Quick Start

Tell your agent:
- *"Design a data pipeline for Postgres to Snowflake"*
- *"Model our sales domain for analytics"*
- *"Audit our data infrastructure"*
- *"Set up data quality for the orders table"*

## ⚡ Level Up

Want industry-specific data engineering context? Our vertical packs include data architecture patterns tailored to your domain:

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — product analytics, usage metering, multi-tenant data
- **[Fintech Context Pack](https://afrexai-cto.github.io/context-packs/)** — transaction pipelines, regulatory reporting
- **[Manufacturing Context Pack](https://afrexai-cto.github.io/context-packs/)** — IoT data streams, supply chain analytics
- **[Healthcare Context Pack](https://afrexai-cto.github.io/context-packs/)** — HIPAA-compliant pipelines, clinical data

**$47 per vertical** → [Browse all packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- `afrexai-database-engineer` — Schema design, query optimization, migrations
- `afrexai-devops-engine` — CI/CD, infrastructure, monitoring
- `afrexai-api-architect` — API design, security, versioning
- `afrexai-data-analyst` — Analysis methodology, visualization, reporting
- `afrexai-compliance-engine` — SOC 2, GDPR, HIPAA readiness

[See all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)
