# Data Analyst — AfrexAI ⚡📊

**Turn your AI agent into a senior data analyst that delivers insights, not just queries.**

Most "data analysis" skills give you SQL templates and call it a day. This one gives you a complete analytical methodology — the same frameworks used by data teams at top companies.

## What's Inside

- **DICE Framework** — Define → Investigate → Communicate → Evaluate (end-to-end analysis methodology)
- **Data profiling & cleaning decision trees** — Know exactly how to handle nulls, outliers, duplicates
- **5-Splits diagnostic method** — Find the root cause of any metric change in minutes
- **Analysis pattern library** — Cohort analysis, RFM segmentation, funnel analysis, A/B test design
- **Insight Formula** — Every finding follows: Insight → Evidence → So What → Now What
- **Visualization selection guide** — Pick the right chart every time
- **Report template** — Executive-ready output format
- **100-point scoring rubric** — Self-evaluate before delivering
- **Statistical significance quick check** — Stop claiming noise is signal
- **Edge case handling** — Timezone traps, survivorship bias, Simpson's paradox, small sample traps
- **Complete sample analysis** — See exactly what good output looks like

## Install

```bash
clawhub install afrexai-data-analyst
```

## Quick Start

Tell your agent: *"Analyze why our conversion rate dropped last month"*

The skill guides your agent through:
1. Defining the business question and success criteria
2. Profiling and cleaning the data
3. Selecting the right analysis technique
4. Structuring findings as actionable insights
5. Formatting a stakeholder-ready report

## Who This Is For

- **Founders** who need to understand their metrics without hiring a data team
- **Operators** who get CSV exports and need to make sense of them
- **Engineers** who can query but struggle with "so what?"
- **Anyone** tired of getting data dumps instead of answers

## ⚡ Level Up Your Data Game

This free skill gives you the methodology. Want the full vertical context?

Our **$47 Context Packs** add industry-specific KPIs, benchmarks, and analysis templates:

- **SaaS Pack** — MRR analysis, churn cohorts, unit economics, SaaS benchmarks
- **Ecommerce Pack** — AOV optimization, cart abandonment, inventory analysis
- **Fintech Pack** — Transaction monitoring, risk scoring, regulatory reporting
- **Manufacturing Pack** — OEE analysis, defect tracking, supply chain metrics

👉 [Browse all 10 vertical packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify leads automatically
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — Create SEO content that ranks
- [afrexai-budget-tracker](https://clawhub.com/skills/afrexai-budget-tracker) — Track spending with natural language
- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — Senior-level code reviews
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — Full support operations framework

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) ⚡ — AI that works.*
