# 🛡️ AfrexAI Cybersecurity Engine

Complete cybersecurity assessment, threat modeling, penetration testing, and security program design — all in one agent skill. Zero external dependencies.

## Install

```bash
clawhub install afrexai-cybersecurity-engine
```

## What It Does

Transform your AI agent into a security engineer that can:

- **Assess** any application or infrastructure's security posture in minutes
- **Threat model** using STRIDE+ methodology with risk scoring
- **Audit** against OWASP Top 10 with specific fix patterns and code examples
- **Harden** servers, containers, and cloud environments with copy-paste configs
- **Manage vulnerabilities** with severity SLAs and scanning schedules
- **Respond to incidents** with step-by-step playbooks and communication templates
- **Design security programs** from scratch (quarterly roadmap)
- **Score security** with a 100-point rubric across 8 dimensions

## Quick Start

```
"Audit security of my Node.js API"
"Threat model our payment processing flow"
"Harden my AWS infrastructure"
"Create an incident response plan for our team"
"Score the security of our SaaS platform"
```

## What's Inside

| Phase | Topic | Key Deliverables |
|-------|-------|-----------------|
| 1 | Posture Assessment | 3-tier health check, full assessment brief YAML |
| 2 | Threat Modeling | STRIDE analysis, threat register, priority rules |
| 3 | Application Security | OWASP Top 10 checklists with fix patterns |
| 4 | Infrastructure | Network, container, and cloud hardening configs |
| 5 | Vulnerability Management | Lifecycle, SLAs, report templates, scanning schedule |
| 6 | Incident Response | SEV-1-4 playbooks, post-mortem template, comms |
| 7 | Security Headers | Copy-paste HTTP headers and cookie config |
| 8 | Auth Deep Dive | Password policy, JWT checklist, OAuth/OIDC |
| 9 | Security Program | 4-quarter roadmap, metrics dashboard |
| 10 | Penetration Testing | Recon, 4-phase testing, report template |
| 11 | Supply Chain | Dependency security, SBOM, build pipeline |
| 12 | Security Scoring | 100-point rubric across 8 dimensions |

## ⚡ Level Up

This skill covers methodology. For **industry-specific security compliance** (HIPAA, PCI DSS, SOX controls mapped to your vertical):

- [Healthcare AI Context Pack](https://afrexai-cto.github.io/context-packs/) — HIPAA security + PHI handling
- [Fintech AI Context Pack](https://afrexai-cto.github.io/context-packs/) — PCI DSS + SOX compliance
- [Legal AI Context Pack](https://afrexai-cto.github.io/context-packs/) — Data protection + privilege

**$47 per pack** — deep industry context your agent can't get from a generic skill.

## 🔗 More Free Skills by AfrexAI

- [afrexai-compliance-engine](https://clawhub.com/skills/afrexai-compliance-engine) — SOC 2, ISO 27001, GDPR, HIPAA compliance
- [afrexai-risk-management](https://clawhub.com/skills/afrexai-risk-management) — Enterprise risk management system
- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — DevOps & platform engineering
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — API lifecycle & security
- [afrexai-code-reviewer](https://clawhub.com/skills/afrexai-code-reviewer) — Code review with SPEAR framework

Browse all skills: [clawhub.com/publishers/afrexai-cto](https://clawhub.com/publishers/afrexai-cto)

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
