# Customer Journey Mapping

Map every touchpoint from first click to loyal advocate. Identify drop-off points, emotional peaks, and automation opportunities across your entire customer lifecycle.

## What This Does

Generates a complete customer journey map with:
- **Stage-by-stage breakdown**: Awareness → Consideration → Purchase → Onboarding → Adoption → Expansion → Advocacy
- **Touchpoint inventory**: Every interaction across channels (web, email, chat, phone, social, in-app)
- **Emotion mapping**: Customer sentiment at each stage (frustrated, neutral, delighted)
- **Drop-off analysis**: Where you're losing people and why
- **Automation opportunities**: Which touchpoints can be handled by AI agents
- **Metrics per stage**: Conversion rates, time-in-stage, cost-to-serve

## Usage

Tell your agent:
- "Map our customer journey from first touch to renewal"
- "Identify the biggest drop-off points in our funnel"
- "Show me where AI agents can replace manual touchpoints"
- "Build a journey map for our [industry] product"

## Journey Stage Framework

### Stage 1: Awareness
- **Channels**: SEO, paid ads, social, referrals, events, content
- **Key metric**: Cost per qualified visitor
- **Common drop-off**: Irrelevant landing page, slow load, unclear value prop
- **Automation opportunity**: AI-powered content personalization, chatbot qualification

### Stage 2: Consideration
- **Channels**: Website, comparison pages, reviews, demos, free trials
- **Key metric**: Lead-to-MQL conversion rate (benchmark: 5-15%)
- **Common drop-off**: No social proof, pricing hidden, too many form fields
- **Automation opportunity**: AI chat for instant Q&A, automated demo scheduling

### Stage 3: Purchase
- **Channels**: Sales calls, checkout, contracts, procurement
- **Key metric**: MQL-to-customer rate (benchmark: 2-5%)
- **Common drop-off**: Complex pricing, slow contract turnaround, no urgency
- **Automation opportunity**: AI proposal generation, contract review, payment reminders

### Stage 4: Onboarding
- **Channels**: Welcome emails, setup wizards, training, kickoff calls
- **Key metric**: Time-to-first-value (benchmark: <7 days for SaaS)
- **Common drop-off**: No clear next step, feature overload, missing integration support
- **Automation opportunity**: AI onboarding sequences, automated check-ins, smart tooltips

### Stage 5: Adoption
- **Channels**: In-app guidance, support tickets, knowledge base, CSM touchpoints
- **Key metric**: Feature adoption rate, DAU/MAU ratio
- **Common drop-off**: Users stuck on basic features, support response too slow
- **Automation opportunity**: AI usage nudges, proactive support, automated training paths

### Stage 6: Expansion
- **Channels**: QBRs, upgrade prompts, cross-sell campaigns, account reviews
- **Key metric**: Net Revenue Retention (benchmark: >110% for B2B SaaS)
- **Common drop-off**: No clear upgrade path, ROI not demonstrated, timing wrong
- **Automation opportunity**: AI health scoring, automated QBR prep, expansion triggers

### Stage 7: Advocacy
- **Channels**: NPS surveys, referral programs, case studies, reviews, community
- **Key metric**: NPS score (benchmark: >50), referral rate
- **Common drop-off**: Never asked, no incentive, bad recent experience
- **Automation opportunity**: AI-triggered review requests, referral tracking, testimonial collection

## Touchpoint Scoring Matrix

Rate each touchpoint on:
| Dimension | Score 1-5 | Description |
|-----------|-----------|-------------|
| Frequency | How often customers hit this touchpoint |
| Impact | How much it affects purchase/retention decisions |
| Effort | How much work it takes your team (high = bad) |
| Satisfaction | Current customer satisfaction at this point |
| Automation Potential | Can an AI agent handle this? (5 = fully automatable) |

**Priority formula**: (Impact × Frequency × Automation Potential) / Effort

High score = automate first. Low satisfaction + high impact = fix immediately.

## Drop-Off Diagnostic

When you find a drop-off point, run this checklist:
1. **Data**: What does the funnel show? Exact % dropping at this stage?
2. **Reason**: Survey/interview data? Support tickets mentioning this?
3. **Competitor**: How do competitors handle this stage?
4. **Quick fix**: Can you reduce friction in <1 week?
5. **Automation**: Can an AI agent eliminate this drop-off entirely?
6. **Revenue impact**: If you fix this, what's the $ value? (drop-off % × pipeline value)

## Industry Benchmarks

| Metric | B2B SaaS | Ecommerce | Professional Services |
|--------|----------|-----------|----------------------|
| Visitor → Lead | 2-5% | 1-3% | 3-8% |
| Lead → Customer | 2-5% | 1-4% | 10-25% |
| Time to First Value | 3-14 days | Immediate | 30-90 days |
| Onboarding Completion | 40-60% | N/A | 70-85% |
| 12-month Retention | 85-95% | 20-40% | 70-85% |
| NRR | 100-130% | N/A | 90-110% |
| CAC Payback | 12-18 months | 1-3 months | 6-12 months |

## Output Format

Your journey map should include:
1. **Visual flow**: Stage → Stage with conversion rates between each
2. **Touchpoint inventory**: Every interaction, channel, owner, and automation status
3. **Emotion curve**: Customer sentiment plotted across the journey
4. **Gap analysis**: Where current experience fails vs. ideal
5. **Automation roadmap**: Prioritized list of touchpoints to automate with ROI estimates
6. **90-day action plan**: Quick wins (Week 1-2), medium fixes (Month 1-2), strategic improvements (Month 3)

## ROI of Journey Mapping

Companies that actively manage customer journeys see:
- **54% greater ROI** on marketing (Aberdeen Group)
- **18x faster revenue growth** from improved customer experience (Forrester)
- **$823M additional revenue** over 3 years for a $1B company improving CX by 1 point (Temkin Group)

The math: If your funnel converts 2% end-to-end and journey optimization lifts that to 3%, you just grew revenue 50% without spending more on acquisition.

---

**Need industry-specific journey maps?** Check out our [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — pre-built frameworks for SaaS, Ecommerce, Healthcare, Fintech, and 6 more verticals. $47 each, or grab the [Pick 3 Bundle for $97](https://buy.stripe.com).

**Calculate your automation ROI**: [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)

**Set up your first AI agent**: [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
