# 🚨 Crisis Management & Communications Playbook

**By [AfrexAI](https://afrexai-cto.github.io/context-packs/) — Built by operators who've seen things go wrong.**

The complete crisis management system for businesses. Detect early, respond fast, communicate clearly, recover stronger.

## What This Skill Does

Turns your AI agent into a Crisis Management Officer that can:

- **Assess** any emerging situation with severity classification and blast radius mapping
- **Activate** a structured response team with clear roles and a 60-minute checklist
- **Communicate** using the CARE framework with ready-made templates for 6+ crisis types
- **Navigate** media inquiries, regulatory notifications, and legal holds
- **Recover** with a 30-day reputation repair roadmap
- **Prepare** with readiness audits, tabletop exercises, and scenario planning

## Install

```bash
clawhub install afrexai-crisis-management
```

## Quick Start

Just describe your situation:

> "We just discovered that customer data may have been exposed through a vendor breach. What do we do?"

The agent will immediately:
1. Classify severity (SEV-1 through SEV-4)
2. Provide the activation checklist
3. Draft your first holding statement
4. Map regulatory notification deadlines
5. Create a stakeholder communication plan

## What's Inside

- **Severity Matrix** — 4-level classification with response times and team composition
- **12 Early Warning Signals** — detect crises before they explode
- **CARE Communication Framework** — Concern, Accountability, Remedy, Evolution
- **6 Statement Templates** — data breach, product failure, executive departure, layoffs, and more
- **Media Management Protocol** — press inquiry handling, spokesperson rules, social media tiers
- **Legal & Regulatory Guide** — notification deadlines for GDPR, HIPAA, SEC, state laws, PIPEDA, and more
- **30-Day Recovery Plan** — week-by-week reputation repair roadmap
- **Crisis Readiness Audit** — 10-dimension preparedness scoring (1-50)
- **Tabletop Exercise Template** — 90-minute simulation with escalating injects
- **Industry-Specific Guides** — SaaS, Healthcare, Financial Services, Legal, Construction/Manufacturing
- **100-Point Response Scoring** — rate your crisis response across 7 weighted dimensions
- **12 Natural Language Commands** — just ask in plain English

## Example Commands

```
"Crisis assessment for a journalist asking about our data practices"
"Draft a crisis statement about our 4-hour service outage"
"Run a tabletop exercise for a ransomware attack"
"Regulatory notification checklist for a data breach affecting EU customers"
"Rate our crisis response to last week's incident"
```

---

## ⚡ Level Up Your Crisis Preparedness

This free skill gives you the methodology. Our **industry-specific context packs** give you deep, vertical-specific playbooks:

- **[SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — SaaS-specific outage, breach, and churn crisis playbooks
- **[Healthcare Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — HIPAA crisis response, patient safety protocols
- **[Legal Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — Attorney misconduct, client data breach, bar reporting
- **[Financial Services Context Pack ($47)](https://afrexai-cto.github.io/context-packs/)** — Trading errors, AML, regulatory action response

## 🔗 More Free Skills by AfrexAI

- **[afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support)** — Complete support operations with SLA management and churn prevention
- **[afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy)** — Brand building and positioning (protect what you've built)
- **[afrexai-stakeholder-management](https://clawhub.com/skills/afrexai-stakeholder-management)** — Manage stakeholders during and after crises
- **[afrexai-strategic-thinking](https://clawhub.com/skills/afrexai-strategic-thinking)** — Decision-making frameworks for high-stakes moments
- **[afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook)** — Recover and retain clients post-crisis

---

**Browse all AfrexAI skills →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
