# Crisis Communication Playbook

Generate a crisis communication plan with holding statements, stakeholder messaging, media responses, and internal comms templates.

## Usage

Tell the agent:
- "We have a data breach — draft crisis comms"
- "Customer-facing outage — prepare stakeholder updates"
- "PR crisis — generate a response framework"

## What It Produces

1. **Severity Assessment** — P1 (existential) through P4 (minor) classification
2. **Holding Statement** — Immediate public response (deploy in <30 minutes)
3. **Stakeholder Matrix** — Who needs to know, what they need to hear, when
4. **Media Q&A** — Prepared answers for likely journalist questions
5. **Internal Comms** — Employee briefing, leadership talking points
6. **Social Media Response** — Platform-specific messaging
7. **Timeline** — Hour-by-hour communication schedule for first 72 hours
8. **Post-Crisis Review** — Lessons learned template

## Crisis Types Covered

- Data breaches and security incidents
- Service outages and technical failures
- Product recalls or safety issues
- Executive departures or legal actions
- Negative press or social media storms
- Regulatory investigations
- Financial restatements

## Framework

Every crisis response follows the **ACE model**:
- **Acknowledge** — Confirm awareness, show empathy
- **Commit** — State what you're doing about it
- **Explain** — Provide context without making excuses

## Tone Guidelines

- Human first, corporate second
- Specific commitments over vague promises
- Take ownership — never deflect blame
- Update frequently — silence is the enemy

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for business teams.

Need a full communications framework? Check our [Professional Services Context Pack ($47)](https://afrexai-cto.github.io/context-packs/) or run our free [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/).
