---
name: afrexai-copywriting-mastery
description: "Write high-converting copy for any medium — landing pages, emails, ads, UX, sales pages, video scripts, and brand voice. Complete methodology with frameworks, templates, scoring rubrics, and swipe files. Use when writing or reviewing any user-facing text."
metadata:
  author: AfrexAI
  version: "1.0.0"
  tags: ["copywriting", "marketing", "sales copy", "UX writing", "conversion", "landing page", "email copy", "ads"]
---

# Copywriting Mastery

Complete copywriting system — from research to revision. Write copy that converts for landing pages, emails, ads, UX, sales pages, video scripts, and any user-facing text.

## Quick Copy Health Check

Run `/copy-check` on any draft:

| # | Check | Pass? |
|---|-------|-------|
| 1 | Does the headline pass the "so what?" test? | |
| 2 | Is the reader's #1 objection addressed? | |
| 3 | Can a 12-year-old understand it? | |
| 4 | Is there ONE clear CTA per section? | |
| 5 | Does it lead with benefit, not feature? | |
| 6 | Would you stop scrolling for this? | |
| 7 | Is every sentence earning its place? | |
| 8 | Does it sound like a human wrote it? | |

Score: X/8. Below 6 = rewrite before publishing.

---

## Phase 1: Research Before Writing

Never write cold. Every piece of copy starts with research.

### Customer Voice Mining

Where to find real language your audience uses:

| Source | What to extract | Priority |
|--------|----------------|----------|
| Amazon reviews (competing products) | Frustrations, desired outcomes, exact phrases | 🔴 High |
| Reddit/forums in your niche | Problems described in their own words | 🔴 High |
| Support tickets / chat logs | Common questions, confusion points, language | 🔴 High |
| Sales call transcripts | Objections, decision triggers, deal-breakers | 🔴 High |
| Competitor landing pages | Claims, positioning, gaps they miss | 🟡 Medium |
| Social comments on competitor posts | Complaints, wishes, unmet needs | 🟡 Medium |
| Survey responses | Self-described goals and frustrations | 🟡 Medium |

### Voice-of-Customer Brief

```yaml
audience:
  who: "[specific person, not demographic]"
  current_state: "[what life/work looks like now]"
  desired_state: "[what they want it to look like]"
  biggest_frustration: "[in their exact words]"
  trigger_event: "[what makes them search for a solution NOW]"

messaging:
  primary_desire: "[the one outcome they'd pay anything for]"
  top_3_objections:
    - "[objection 1 — in their language]"
    - "[objection 2]"
    - "[objection 3]"
  proof_they_need: "[what evidence would convince them]"
  words_they_use: ["[exact phrases from research]"]
  words_to_avoid: ["[jargon, corporate speak they hate]"]
```

### Awareness Level Assessment

Every reader sits at one of 5 levels. Your copy must match:

| Level | They know... | Your job | Lead with |
|-------|-------------|----------|-----------|
| **Unaware** | Nothing about the problem | Agitate the problem | Story / pattern interrupt |
| **Problem-aware** | They have a problem | Show a solution exists | Empathy + "there's a better way" |
| **Solution-aware** | Solutions exist | Why YOUR solution | Differentiation + proof |
| **Product-aware** | Your product | Why NOW | Offer + urgency + risk reversal |
| **Most-aware** | Everything | Just the deal | Price + CTA + deadline |

**Rule: Most copy fails because it's written for the wrong awareness level.**

---

## Phase 2: Headline Engineering

The headline does 80% of the work. If nobody reads past it, nothing else matters.

### 8 Headline Formulas That Work

| # | Formula | Example |
|---|---------|---------|
| 1 | **How to [desired outcome] without [pain]** | "How to double your revenue without hiring another sales rep" |
| 2 | **[Number] [things] that [benefit]** | "7 email subject lines that get 40%+ open rates" |
| 3 | **The [adjective] way to [outcome]** | "The laziest way to build a 6-figure newsletter" |
| 4 | **Why [common belief] is wrong** | "Why 'more content' is killing your conversion rate" |
| 5 | **[Do thing] like [aspirational identity]** | "Write proposals like a top-1% closer" |
| 6 | **[Specific result] in [timeframe]** | "First paying customer in 14 days" |
| 7 | **Stop [mistake]. Start [better thing].** | "Stop guessing your pricing. Start using data." |
| 8 | **What [authoritative group] knows about [topic]** | "What top SaaS founders know about churn that you don't" |

### Headline Quality Test

Score each headline 1-5 on:

| Dimension | 1 (Weak) | 5 (Strong) |
|-----------|----------|------------|
| **Specificity** | Vague promise | Exact number/result |
| **Curiosity** | Predictable | "I need to know more" |
| **Relevance** | Generic | Speaks to MY situation |
| **Clarity** | Confusing | Instantly understood |
| **Urgency** | "Whenever" | "I need this now" |

Total ≥ 20 = publish. 15-19 = tweak. Below 15 = rewrite.

### Headline Anti-Patterns

- ❌ Clever puns nobody gets
- ❌ Questions the reader answers "no" to
- ❌ Longer than 12 words (for ads/emails)
- ❌ Leading with your company name
- ❌ Using "we" instead of "you"

---

## Phase 3: Core Copy Frameworks

### PAS — Problem, Agitation, Solution

Best for: email, short-form, ads, social posts.

```
[PROBLEM] — Name the specific pain they feel right now.
[AGITATION] — Twist the knife. What happens if they don't fix it? What's it costing them?
[SOLUTION] — Here's how to fix it. Introduce your product/service.
```

**Example:**
> Your sales team spends 3 hours a day on manual data entry. (Problem)
>
> That's 15 hours a week per rep — $78,000/year in lost selling time across a 10-person team. Your competitors automated this last quarter. (Agitation)
>
> SalesFlow syncs your CRM in real-time. Zero manual entry. Your reps sell; the system handles the rest. (Solution)

### AIDA — Attention, Interest, Desire, Action

Best for: landing pages, sales pages, long-form.

| Stage | Job | Technique |
|-------|-----|-----------|
| **Attention** | Stop the scroll | Bold claim, surprising stat, pattern interrupt |
| **Interest** | Keep them reading | Story, empathy, "me too" moment |
| **Desire** | Make them want it | Benefits, social proof, future pacing |
| **Action** | Get the click | Clear CTA, urgency, risk reversal |

### BAB — Before, After, Bridge

Best for: case studies, testimonials, transformation stories.

```
[BEFORE] — Paint their current painful reality.
[AFTER] — Show the transformed state they want.
[BRIDGE] — Your product/service is the bridge between the two.
```

### 4U Framework — Urgent, Unique, Ultra-specific, Useful

Best for: headlines, subject lines, CTAs. Score each element 1-4.

### PASTOR — Problem, Amplify, Story, Testimony, Offer, Response

Best for: long-form sales pages, webinar scripts, VSLs.

```
Problem: Name it in their words
Amplify: What happens if they ignore it (emotional + financial cost)
Story: Your/client's journey through the same problem
Testimony: Social proof from people like them
Offer: Present the solution with clear value stack
Response: Tell them exactly what to do next
```

---

## Phase 4: Copy by Medium

### Landing Pages

**Structure (top to bottom):**

1. **Hero section**: Headline + subhead + CTA + hero image
2. **Problem section**: 3 pain points with empathy
3. **Solution section**: How it works (3 steps max)
4. **Benefits section**: Feature → Benefit → Proof for top 3-5 features
5. **Social proof**: Testimonials, logos, numbers
6. **Objection handling**: FAQ addressing top 3 concerns
7. **Final CTA**: Restate value prop + urgency + risk reversal

**Landing page rules:**
- One page = one goal = one CTA (repeated 3+ times)
- Above the fold: headline, subhead, CTA, visual. Nothing else.
- Feature → Benefit translation: "We have X" → "You get Y, which means Z"
- Remove navigation (reduce exit points)
- Social proof near every CTA
- Page load < 3 seconds

**Conversion benchmarks:**
| Traffic source | Good | Great |
|---------------|------|-------|
| Cold ads | 3-5% | 8%+ |
| Email list | 10-15% | 25%+ |
| Organic/SEO | 5-8% | 12%+ |
| Referral | 8-12% | 20%+ |

### Email Copy

**Subject line formulas:**
| Type | Formula | Example |
|------|---------|---------|
| Curiosity gap | "[partial reveal]..." | "The pricing mistake that cost us $47K..." |
| Direct benefit | "How to [get result]" | "How to close 3x more deals this month" |
| Social proof | "[Name/company] did [result]" | "How Stripe grew 10x with one email change" |
| Urgency | "[Deadline] for [thing]" | "Last day for early-bird pricing" |
| Personal | "Quick question, [name]" | "Quick question, Sarah" |

**Email body rules:**
- First line = hook (never "I hope this email finds you well")
- One idea per email
- Write at 5th-grade reading level
- CTA button + text link (both)
- P.S. line gets read — put your best hook or proof there
- Mobile-first: short paragraphs, 1-3 sentences each

### Ad Copy (Facebook / Google / LinkedIn)

**Facebook/Instagram ad structure:**
```
[Hook — 1 line that stops the scroll]
[Problem — 1-2 lines of empathy]
[Solution — what you offer, 1-2 lines]
[Proof — one specific result or testimonial]
[CTA — clear next step with low friction]
```

**Google Search ads:**
- Headline 1: Include exact search keyword
- Headline 2: Benefit or differentiator
- Headline 3: CTA or trust signal
- Description: Address the intent behind the search, not just the keyword

**LinkedIn ad rules:**
- Professional tone but not corporate
- Lead with industry-specific insight
- Use "you" more than "we"
- Stats outperform stories on LinkedIn

### UX Copy

**Microcopy decision table:**

| Element | Pattern | Example |
|---------|---------|---------|
| **Buttons** | Verb + Object | "Save Changes", "Start Trial" |
| **Errors** | What happened + How to fix | "Email already registered. Try logging in?" |
| **Empty states** | What goes here + How to start | "No projects yet. Create your first one." |
| **Loading** | What's happening + Expectation | "Generating your report... about 10 seconds." |
| **Success** | What happened + Next step | "Payment confirmed! Check your email for receipt." |
| **Confirmation** | Consequence + Escape hatch | "Delete this project? This can't be undone. [Cancel] [Delete]" |
| **Tooltips** | One sentence max | "Your display name visible to other members." |
| **Placeholder text** | Example format, not label | "jane@company.com" not "Enter your email" |
| **404 page** | Empathy + Direction | "Page not found. Try searching or go home." |
| **Onboarding** | Benefit of completing step | "Add your logo so clients see your brand." |

**UX writing rules:**
- Lead with the verb
- No double negatives
- Front-load the important word
- Same word = same meaning everywhere (consistency)
- Error messages: never blame the user

### Sales Pages (Long-Form)

**Sales page blueprint (PASTOR extended):**

1. **Pattern interrupt headline** (curiosity + specificity)
2. **Opening story** (relatable struggle → discovery → transformation)
3. **Problem amplification** (emotional + financial cost of inaction)
4. **The "aha" moment** (insight that makes your solution inevitable)
5. **Solution introduction** (what it is, how it works, why it's different)
6. **Value stack** (everything they get — list each component with value)
7. **Social proof block** (3-5 testimonials with specific results)
8. **Objection crusher** (FAQ with embedded selling)
9. **Risk reversal** (guarantee with specific terms)
10. **Urgency/scarcity** (real deadline or limited availability)
11. **Final CTA** (restate transformation + exact next step)
12. **P.S.** (restate biggest benefit + guarantee + deadline)

### Video Scripts (VSL / YouTube)

**Hook formula (first 5 seconds):**
```
[Surprising claim or result] + [Why you should keep watching]
"We went from 0 to $1M ARR in 9 months using a system most founders ignore. Here's the framework."
```

**VSL structure:**
1. Hook (0-15 sec): Bold claim + qualify viewer
2. Problem (15-60 sec): Their situation, what they've tried, why it failed
3. Story (1-3 min): Your journey through same problem
4. Solution (3-5 min): The framework/system (teach, don't pitch)
5. Proof (5-6 min): Case studies, screenshots, testimonials
6. Offer (6-7 min): What they get, what it's worth, what they pay
7. CTA (7-8 min): Exactly what to do next + urgency

---

## Phase 5: Persuasion Techniques

### Feature → Benefit → "So What" Chain

Never stop at the feature. Go 3 levels deep:

| Level | Question | Example |
|-------|----------|---------|
| **Feature** | What is it? | "AI-powered email sorting" |
| **Benefit** | What does it do for me? | "Saves you 45 minutes every morning" |
| **So What** | Why does that matter? | "That's 15 extra hours a month to close deals instead of managing inbox" |

**Rule: Always write at the "So What" level.**

### Social Proof Hierarchy

Most persuasive → least persuasive:

1. **Specific results** — "$47K in 30 days" beats "great results"
2. **Named testimonials with photo** — Real people > anonymous quotes
3. **Logos of recognizable companies** — "Trusted by Stripe, Notion, Linear"
4. **Numbers at scale** — "12,847 teams use this" (odd numbers feel more real)
5. **Media mentions** — "Featured in TechCrunch"
6. **Certifications / awards** — SOC2, G2 badges
7. **Generic quotes** — "This is amazing!" (weakest — avoid if possible)

### Objection Handling in Copy

| Objection Type | Copy Technique | Example |
|---------------|---------------|---------|
| "Too expensive" | Reframe as cost of inaction | "A single missed deal costs more than a year of this tool" |
| "Don't have time" | Show time savings | "Setup takes 7 minutes. Most users save 2 hours/week by day 3" |
| "We already have something" | Differentiate + switching cost is low | "Import your existing data in one click" |
| "Not sure it works" | Risk reversal + proof | "60-day guarantee. Plus, here's what [similar company] achieved" |
| "Need to ask my boss" | Give them ammo | "Here's a one-page business case to share with your team" |
| "I'll do it later" | Urgency + future cost | "Every week you wait costs ~$2,400 in manual work" |

### Power Words by Emotion

| Emotion | Words |
|---------|-------|
| **Urgency** | Now, today, limited, deadline, before, expires, last chance |
| **Trust** | Guaranteed, proven, secure, certified, verified, backed |
| **Curiosity** | Secret, hidden, little-known, surprising, discover, reveal |
| **Exclusivity** | Members-only, invitation, insider, private, handpicked |
| **Value** | Free, save, bonus, extra, included, no-cost, complimentary |
| **Achievement** | Master, unlock, dominate, breakthrough, elite, accelerate |

### Words to Cut

| Remove | Replace with | Why |
|--------|-------------|-----|
| "Very" | Stronger adjective | "Very good" → "excellent" |
| "Really" | Nothing | Dead weight |
| "In order to" | "To" | 3 words → 1 |
| "I think" / "I believe" | State directly | Weakens authority |
| "Leverage" | "Use" | Corporate jargon |
| "Utilize" | "Use" | Same |
| "Streamline" | Be specific | What does it actually do? |
| "Best-in-class" | Prove it | Claims without proof = noise |
| "Cutting-edge" | Describe the innovation | Show, don't label |

---

## Phase 6: Brand Voice System

### Voice Definition Template

```yaml
brand_voice:
  personality: "[3 adjectives — e.g., bold, clear, warm]"
  
  we_are:
    - "[trait 1 with example]"
    - "[trait 2 with example]"
    - "[trait 3 with example]"
  
  we_are_not:
    - "[anti-trait 1 with example]"
    - "[anti-trait 2 with example]"
    - "[anti-trait 3 with example]"
  
  tone_spectrum:
    formal_casual: 7  # 1=corporate, 10=slang
    serious_playful: 6  # 1=grave, 10=goofy
    technical_simple: 4  # 1=jargon-heavy, 10=ELI5
    reserved_enthusiastic: 7  # 1=muted, 10=exclamation marks
  
  vocabulary:
    always_use: ["build", "ship", "grow", "earn"]
    never_use: ["synergy", "leverage", "holistic", "paradigm"]
    our_terms:
      - internal: "user" → our_word: "builder"
      - internal: "subscription" → our_word: "membership"
  
  punctuation:
    contractions: true  # "we're" not "we are"
    exclamation_marks: "sparingly — max 1 per page"
    em_dashes: "yes — for emphasis and asides"
    oxford_comma: true
```

### Voice Consistency Checker

Run on any draft:

| # | Check | Pass? |
|---|-------|-------|
| 1 | Uses approved vocabulary? | |
| 2 | Matches tone spectrum (±1 point)? | |
| 3 | No banned words? | |
| 4 | Consistent with "we are / we are not"? | |
| 5 | Punctuation follows guide? | |
| 6 | Could be read aloud naturally? | |
| 7 | Sounds like the same person across all sections? | |

---

## Phase 7: Editing & Revision

### The 3-Pass Edit

| Pass | Focus | Method |
|------|-------|--------|
| **1. Meaning** | Is the message right? | Read as if you know nothing about the product |
| **2. Flow** | Does it read smoothly? | Read aloud — where do you stumble? |
| **3. Trim** | Is every word earning its place? | Cut 20-30% of word count |

### Copy Tightening Techniques

| Before | After | Technique |
|--------|-------|-----------|
| "We are in the process of building" | "We're building" | Kill gerunds |
| "There are many reasons why" | "Here's why" | Cut throat-clearing |
| "It is important to note that" | [delete] | Remove qualifiers |
| "Our product helps you to be able to" | "Our product lets you" | Direct verb |
| "A total of 47 customers" | "47 customers" | Drop filler |
| "At this point in time" | "Now" | Plain English |
| "Due to the fact that" | "Because" | Simplify |

### Readability Targets

| Medium | Grade level | Sentence length |
|--------|------------|----------------|
| Social media | 5th grade | 8-12 words |
| Email | 6th-8th grade | 10-15 words |
| Landing page | 7th-8th grade | 12-18 words |
| Blog post | 8th-9th grade | 15-20 words |
| Technical docs | 10th-12th grade | 18-25 words |

### AI Copy Detection & Humanization

Signs your copy sounds AI-generated:
- Starts with "In today's fast-paced world"
- Uses "leverage", "streamline", "revolutionize"
- Lists exactly 3 things every time (rule of three)
- Em-dash overuse
- "It's important to note that..."
- Vague attributions ("experts say", "many believe")
- Perfect parallel structure in every list
- No contractions

Fix: Read it aloud. Would a smart friend say this at a bar? If not, rewrite.

---

## Phase 8: Conversion Optimization

### CTA Writing Rules

| Rule | Bad | Good |
|------|-----|------|
| Verb + benefit | "Submit" | "Get My Free Report" |
| First person | "Start your trial" | "Start my free trial" |
| Reduce friction | "Buy now" | "Try free for 14 days" |
| Create continuity | "Sign up" | "Continue to checkout" |
| Match awareness | "Learn more" (aware) | "See pricing" (ready) |

### CTA Placement Strategy

- After every major section (not just at the bottom)
- Immediately after social proof
- After addressing an objection
- In hero section (above the fold)
- Floating/sticky on long pages
- **Rule: Minimum 3 CTAs on any page longer than 2 screens**

### Pricing Page Copy

| Element | Copy rule |
|---------|-----------|
| Plan names | Describe the customer, not the plan ("Starter" → "Solo Creator") |
| Feature lists | Benefits, not features ("500GB storage" → "Never worry about running out of space") |
| Recommended plan | Visual highlight + "Most Popular" badge |
| Annual vs monthly | Show savings as $ amount, not % |
| Guarantee | Below pricing, not buried in FAQ |
| Social proof | Right next to the buy button |

### A/B Testing Copy Elements

Priority order (highest impact first):
1. Headlines (test first, always)
2. CTA button text
3. Social proof placement/format
4. Hero section subhead
5. Pricing page plan names
6. Email subject lines
7. Body copy structure

**Minimum sample: 1,000 visitors or 100 conversions per variant before calling a winner.**

---

## Phase 9: Swipe File — Ready-to-Adapt Templates

### Welcome Email Template

```
Subject: You're in — here's your first win

[First name],

Welcome to [product].

The fastest way to see results:

1. [First action — takes 2 minutes]
2. [Second action — shows immediate value]
3. [Third action — "aha" moment]

Most [product] users see [specific result] within [timeframe].

If you get stuck, reply to this email. A human reads every one.

[Signature]

P.S. [One bonus tip or resource link]
```

### Cold Outreach Template (B2B)

```
Subject: [Specific observation about their company]

Hey [name],

Noticed [specific thing — recent hire, product launch, job posting].

That usually means [educated guess about their challenge].

We helped [similar company] [specific result] by [method in one sentence].

Worth a 15-minute call to see if it fits?

[Signature]
```

### Testimonial Request Template

```
Subject: Quick favor? (takes 2 min)

Hey [name],

Loved hearing that [specific result they mentioned].

Would you mind sharing that as a quick testimonial? Here's a format that makes it easy:

- What were you struggling with before?
- What result did you get?
- What would you say to someone considering [product]?

Even 2-3 sentences would be incredible.

[Signature]
```

### Feature Announcement Template

```
Subject: [New feature] is live — here's why it matters

[First name],

You asked for [thing]. We built it.

[Feature name] lets you [benefit in one sentence].

Here's what changes:
- [Before]: [old painful way]
- [After]: [new easy way]

[Screenshot or GIF]

[CTA: Try it now]

[Signature]
```

---

## Phase 10: Copy Scoring Rubric

Rate any piece of copy 0-100:

| Dimension | Weight | 0-2 (Weak) | 3-4 (Solid) | 5 (Exceptional) |
|-----------|--------|------------|-------------|-----------------|
| **Clarity** | 20% | Confusing, jargon-heavy | Clear to target audience | Crystal clear to anyone |
| **Specificity** | 15% | Vague claims | Some numbers/details | Precise, verifiable claims |
| **Persuasion** | 15% | Lists features | Connects to benefits | "So What" chain on every point |
| **Voice** | 15% | Generic / AI-sounding | Consistent, on-brand | Distinctive, memorable |
| **Structure** | 10% | Wall of text | Good flow with headers | Perfect progressive disclosure |
| **CTA Strength** | 10% | "Submit" | Clear next step | Irresistible with friction removed |
| **Social Proof** | 10% | None or generic | Present and relevant | Specific results from similar buyers |
| **Objection Handling** | 5% | Ignores concerns | Addresses top objection | Pre-empts all major objections |

**Scoring:** 85+ = publish. 70-84 = one more edit pass. Below 70 = significant rewrite needed.

---

## Phase 11: Industry-Specific Copywriting

### SaaS Copy

- Lead with the metric they care about (MRR, churn rate, time saved)
- Use "your team" not "users" — B2B buyers picture their team
- Competitor comparison tables work (be honest, highlight your strengths)
- Free trial > demo request for products under $500/mo
- Security/compliance badges matter — put them near CTAs

### Ecommerce Copy

- Product descriptions: benefits first, specs second
- Use sensory language ("buttery-soft leather" not "high-quality material")
- Urgency: stock levels, shipping deadlines, limited runs
- Size/fit guides reduce returns — invest in clear copy here
- Reviews with photos > star ratings alone

### Professional Services Copy

- Credibility first: years of experience, case results, credentials
- Address the "do I need this?" question before "why you?"
- Process transparency: show exactly what happens after they hire you
- Use "when" not "if" — assume the engagement: "when we start your project"

### Healthcare / Regulated Copy

- Compliance first — no unsubstantiated claims
- Empathy + authority: "We understand [condition] because [credential]"
- Clear disclaimers without burying them
- Accessibility: plain language, alt text, screen-reader friendly

---

## Phase 12: Advanced Techniques

### Storytelling in Copy

**Micro-story formula (50-100 words):**
```
[Character with relatable problem] → [Tried common solution, failed] → [Discovered different approach] → [Specific result]
```

**When to use stories:** Opening hooks, case studies, "about us" sections, testimonial framing, email openers.

### Anchoring

Set a high reference point before revealing your price:
- "Companies spend $50,000/year on this manually. Our tool costs $299/month."
- "A single missed deal costs $15,000. This training is $497."

### Future Pacing

Help the reader imagine life after buying:
- "Imagine opening your laptop Monday morning and seeing..."
- "Six months from now, your team will..."
- "Picture this: you wake up to 3 new leads already qualified..."

### Pattern Interrupts

Break expected copy patterns to re-engage attention:
- One-word paragraphs: "Stop."
- Direct questions mid-flow: "Still with me?"
- Unexpected honesty: "This product isn't for everyone."
- Format breaks: bold a single word in a long paragraph

### Scarcity & Urgency (Ethical)

| Ethical ✅ | Unethical ❌ |
|-----------|-------------|
| Real deadline (cohort closes Friday) | Fake countdown timers |
| Limited capacity (we take 5 clients/month) | "Only 2 left!" (lie) |
| Early-bird pricing with end date | Perpetual "sale" pricing |
| Beta pricing grandfathered in | Hidden price increases |

---

## Common Copy Mistakes

| # | Mistake | Fix |
|---|---------|-----|
| 1 | Writing about yourself instead of the reader | Ctrl+F "we/our" — flip to "you/your" |
| 2 | Features without benefits | Add "which means..." after every feature |
| 3 | No clear CTA | One CTA per section, specific verb + benefit |
| 4 | Burying the lead | Move your best point to the first line |
| 5 | Too many ideas per page/email | One message. One CTA. One goal. |
| 6 | Weak headline | Write 25 variations, pick the best |
| 7 | No social proof | Add before publishing — even one testimonial helps |
| 8 | Corporate jargon | Read aloud test: would a friend say this? |
| 9 | Ignoring mobile readers | Short paragraphs, big buttons, scannable headers |
| 10 | Never testing | A/B test headlines first, then CTAs |

---

## Natural Language Commands

| Command | What it does |
|---------|-------------|
| `/copy-check` | Run the 8-point health check on a draft |
| `/headline [topic]` | Generate 10 headline options with scoring |
| `/rewrite [text]` | Tighten and improve existing copy |
| `/email [type] [topic]` | Draft email using appropriate framework |
| `/landing-page [product]` | Generate full landing page copy structure |
| `/ad [platform] [product]` | Write platform-specific ad copy |
| `/ux [element] [context]` | Write microcopy for specific UI element |
| `/voice-check [text]` | Check copy against brand voice definition |
| `/objection [concern]` | Write objection-handling copy |
| `/testimonial-request` | Generate testimonial collection email |
| `/score [text]` | Score copy on 0-100 rubric |
| `/swipe [type]` | Get a ready-to-adapt template |

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI agent skills that actually work.*
