# Copywriting Mastery ✍️

Complete copywriting system for AI agents — research, write, edit, and optimize copy that converts. Landing pages, emails, ads, UX, sales pages, video scripts, and brand voice.

## Install

```bash
clawhub install afrexai-copywriting-mastery
```

## What You Get

- **27KB of actionable methodology** — not tips, not bullet points, a complete system
- 8-point copy health check for instant draft assessment
- Voice-of-customer research framework with mining sources
- 8 proven headline formulas with quality scoring
- 5 core copy frameworks (PAS, AIDA, BAB, 4U, PASTOR) with full examples
- Copy templates for 7 mediums: landing pages, emails, ads, UX, sales pages, video scripts, pricing pages
- Brand voice definition system with consistency checker
- 3-pass editing method with tightening techniques
- Conversion optimization: CTA rules, A/B testing priorities, pricing page copy
- 4 ready-to-adapt swipe file templates (welcome email, cold outreach, testimonial request, feature announcement)
- 100-point copy scoring rubric across 8 weighted dimensions
- Industry-specific guides: SaaS, Ecommerce, Professional Services, Healthcare
- Advanced techniques: storytelling, anchoring, future pacing, ethical urgency
- 10 common mistakes with specific fixes
- 12 natural language commands
- Zero dependencies — works with any AI agent

## Quick Start

```
/copy-check          → Audit any draft in 30 seconds
/headline [topic]    → Get 10 scored headline options
/landing-page [product] → Full landing page copy structure
/email cold [topic]  → Cold outreach email with framework
/rewrite [text]      → Tighten and improve existing copy
/score [text]        → 0-100 quality score with breakdown
```

## ⚡ Level Up

This free skill covers methodology. For industry-specific copy frameworks, objection libraries, and conversion playbooks:

**[$47 Context Packs](https://afrexai-cto.github.io/context-packs/)** — Deep-dive packs for SaaS, Ecommerce, Healthcare, Legal, Fintech, Construction, Real Estate, Recruitment, Manufacturing, and Professional Services.

## 🔗 More Free Skills by AfrexAI

- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content strategy & writing
- [afrexai-email-marketing-engine](https://clawhub.com/skills/afrexai-email-marketing-engine) — Complete email marketing system
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — B2B sales methodology
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand identity & positioning
- [afrexai-social-media-engine](https://clawhub.com/skills/afrexai-social-media-engine) — Multi-platform content system

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**

---

*Built by AfrexAI 🖤💛 — AI agent skills that actually work.*
