# Contract Review Assistant

Stop signing contracts blind. This skill turns your AI agent into a contract analyst that flags risks, spots missing protections, and builds your negotiation checklist — in seconds, not billable hours.

## What You Get
- **Plain-English summaries** of dense legal language
- **Red/Yellow/Green risk scoring** on every clause
- **Missing clause detection** (termination, data ownership, SLAs, liability caps)
- **Ready-to-send counter-proposals** for every flag

## Who It's For
- Founders reviewing vendor/client contracts
- Ops teams processing procurement agreements
- Freelancers and agencies evaluating client MSAs
- Anyone who doesn't want to pay $500/hr for a first-pass review

## How to Use
Install, then paste any contract text or point to a file. The agent walks through a structured review and delivers a risk report with actionable next steps.

## Go Deeper
- [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific agent configs for Legal, Healthcare, SaaS, and 7 more ($47 each)
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — See what contract review automation saves your team annually
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Get your AI agent configured in 5 minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/).
