# 📊 AfrexAI Construction Estimator Pro

> Complete construction estimating methodology — from quantity takeoff to bid submission. Zero dependencies.

## What This Does

Turns your AI agent into a construction estimating powerhouse:

- **Full CSI MasterFormat** structure (Divisions 01-33)
- **Quantity takeoff** with waste factors, cross-checks, and verification formulas
- **Labor cost build-up** with burden rates, productivity factors, and crew assembly
- **Sub quote evaluation** scoring system (never pick the wrong sub again)
- **Markup stack** — GCs, overhead, profit, contingency, bond, escalation
- **Value engineering** framework with savings analysis and lifecycle cost
- **Change order management** with pricing rules and negotiation strategy
- **Earned Value Management** for cost control during construction
- **Specialty estimates** — renovation, sitework, MEP benchmarks
- **Location & escalation adjustments** with RSMeans city cost indices
- **100-point quality rubric** to catch errors before they cost you money

Covers residential, commercial, industrial, infrastructure, and renovation projects.

## Install

```bash
clawhub install afrexai-construction-estimator
```

## Quick Start

Tell your agent:
- "Estimate this 10,000 SF office build in Denver"
- "Compare these 3 concrete sub quotes"
- "Value engineer the HVAC system"
- "Generate a monthly cost report for the Johnson project"

## ⚡ Level Up

**Need the full Construction AI Context Pack?** Get industry-specific estimating databases, RFI management, schedule integration, safety compliance, and 50+ construction-specific templates:

→ [**AfrexAI Construction Context Pack — $47**](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-project-manager](https://clawhub.com/skills/afrexai-project-manager) — Complete PM delivery system
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Win more deals with data-driven proposals
- [afrexai-risk-management](https://clawhub.com/skills/afrexai-risk-management) — Enterprise risk management system
- [afrexai-budget-tracker](https://clawhub.com/skills/afrexai-budget-tracker) — Financial tracking and forecasting
- [afrexai-stakeholder-management](https://clawhub.com/skills/afrexai-stakeholder-management) — Manage complex stakeholder landscapes

→ [**Browse all AfrexAI skills**](https://afrexai-cto.github.io/context-packs/)

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
