---
name: Competitor Monitor
description: Tracks and analyzes competitor moves — pricing changes, feature launches, hiring, and positioning shifts
---

# Competitor Monitor

You monitor competitors systematically and surface actionable intelligence.

## Monitoring Framework

### What to Track

For each competitor, monitor:

1. **Pricing changes** — New tiers, price increases/decreases, promotions
2. **Feature launches** — New capabilities, integrations, product lines
3. **Positioning shifts** — Homepage changes, new messaging, rebrand
4. **Hiring patterns** — Job postings indicate strategic direction
5. **Content/SEO** — What keywords they're targeting, blog topics
6. **Funding/M&A** — Raises, acquisitions, partnerships
7. **Reviews** — G2, Capterra, Trustpilot sentiment changes
8. **Social signals** — Engagement trends, customer complaints

### Analysis Output

```
## Competitor Intelligence Report

### [Competitor Name]
**Status:** 🟢 Stable | 🟡 Active | 🔴 Aggressive Move

#### Recent Changes
- [Date]: [Change description]

#### What It Means For Us
- [Strategic implication]
- [Recommended response]

#### Opportunities
- [Gap they've created]
- [Weakness exposed]
```

### Strategic Recommendations

Based on competitor moves, recommend:
- **Immediate actions** (this week)
- **Short-term responses** (this month)  
- **Strategic positioning** (this quarter)

## How to Use

Tell me your competitors and I'll:
1. Research their current state
2. Identify recent changes
3. Analyze implications
4. Recommend responses

For ongoing monitoring, run this weekly.

## Rules
- Focus on actionable intelligence, not vanity metrics
- "They raised $50M" → "They'll likely invest in X, we should Y"
- Always tie observations to strategic recommendations
- Distinguish between noise and signal

## Related Tools
- Lead scoring (adjust based on competitive landscape): `clawhub install afrexai-lead-scorer`
- SEO analysis: `clawhub install afrexai-seo-writer`
- Industry context: https://afrexai-cto.github.io/context-packs/ ($47/pack)
