# AfrexAI Competitive Intelligence Engine

Complete competitive intelligence system for your AI agent — market mapping, product teardowns, pricing intel, sales battlecards, win/loss analysis, and strategic monitoring.

## Install

```bash
clawhub install afrexai-competitive-intel
```

## What It Does

Most "competitor analysis" skills stop at SEO keywords. This one covers the **full business intelligence stack**:

| Phase | What You Get |
|-------|-------------|
| **Market Mapping** | 4-tier competitor classification with YAML templates |
| **Product Teardown** | Structured teardown process + UX scoring rubric |
| **Pricing Intelligence** | Total cost comparison + positioning strategy |
| **Sales Battlecards** | Ready-to-use templates with objection handling |
| **Win/Loss Analysis** | Interview framework + trend dashboard |
| **Ongoing Monitoring** | Signal tracking + weekly brief template |
| **Strategic Frameworks** | Moat assessment, response prediction, blue ocean analysis |

## Quick Start

```
"Map my competitive landscape for [your industry]"
"Build a battlecard for [competitor name]"
"Compare our pricing against [competitor 1] and [competitor 2]"
```

## ⚡ Level Up

Want industry-specific competitive frameworks with pre-built battlecards, pricing benchmarks, and market maps?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** include competitive intelligence tailored to your vertical: SaaS, Fintech, Healthcare, Legal, Construction, Ecommerce, Real Estate, Recruitment, Manufacturing, and Professional Services.

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — ICP-driven prospecting engine
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Full pricing system
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Deal-winning proposals
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — DICE analysis framework
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — Content that ranks

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
