# Compensation & Salary Benchmarking Planner

Build data-driven compensation structures that attract talent without overpaying. Covers base salary bands, equity/bonus frameworks, geographic differentials, and total rewards packaging.

## When to Use
- Building or revising salary bands for any role
- Preparing for hiring sprints and need market-rate data
- Conducting annual compensation reviews
- Designing equity/bonus/commission structures
- Benchmarking against competitors to reduce turnover

## How It Works

When asked to build a compensation plan, follow this framework:

### 1. Role Architecture
Define job levels and salary bands:

| Level | Title Pattern | Base Range (US) | Equity % | Bonus Target |
|-------|--------------|-----------------|----------|--------------|
| L1 | Associate / Junior | $45K-$70K | 0-0.01% | 0-5% |
| L2 | Mid-level | $70K-$110K | 0.01-0.05% | 5-10% |
| L3 | Senior | $110K-$160K | 0.05-0.15% | 10-15% |
| L4 | Staff / Lead | $150K-$210K | 0.1-0.3% | 15-20% |
| L5 | Principal / Director | $190K-$280K | 0.2-0.5% | 20-30% |
| L6 | VP / C-level | $250K-$400K+ | 0.5-2%+ | 30-50%+ |

### 2. Geographic Differentials
Apply cost-of-labor multipliers (not cost-of-living):

| Tier | Markets | Multiplier |
|------|---------|------------|
| Tier 1 | SF Bay, NYC, London | 1.0x (baseline) |
| Tier 2 | Seattle, Boston, LA, Chicago | 0.90-0.95x |
| Tier 3 | Austin, Denver, Manchester, Berlin | 0.80-0.85x |
| Tier 4 | Remote US/UK secondary markets | 0.70-0.80x |
| Tier 5 | Eastern Europe, LATAM, SEA | 0.40-0.60x |

### 3. Total Compensation Package
Break down total rewards:

**Cash Compensation**
- Base salary: 60-80% of total comp (varies by seniority)
- Performance bonus: 5-30% of base
- Commission (sales roles): 40-60% of OTE

**Equity Compensation**
- Startup (pre-Series B): 0.01%-2% based on level, 4-year vest, 1-year cliff
- Growth stage: RSUs, lower % but higher dollar value
- Public company: RSU grants refreshed annually

**Benefits & Perks** (typically 20-35% on top of base)
- Health insurance: $6K-$24K/yr employer cost per employee (US)
- 401(k)/pension match: 3-6% of salary
- PTO: 15-25 days (US), 25-33 days (UK/EU statutory + company)
- Learning budget: $1K-$5K/yr
- Remote stipend: $100-$250/mo
- Parental leave: 12-26 weeks (competitive)

### 4. Pay Equity Audit
Run these checks quarterly:

1. **Compa-ratio by role**: Actual pay ÷ midpoint of band. Target: 0.90-1.10
2. **Gender pay gap**: Compare median comp by gender within each level
3. **Tenure compression**: Are new hires making more than 2-year veterans? Fix with retention adjustments
4. **Band penetration**: % of employees above 1.0 compa-ratio (flag if >30%)

### 5. Annual Review Cycle

| Month | Action |
|-------|--------|
| Jan | Market data refresh (Levels.fyi, Glassdoor, Radford, Mercer) |
| Feb | Manager calibration sessions |
| Mar | Budget allocation (typically 3-5% of payroll for merit increases) |
| Apr | Communicate adjustments, effective date |
| Jul | Mid-year equity refresh grants |
| Oct | Prepare next year's comp budget proposal |

### 6. Offer Benchmarking Checklist
Before extending any offer:
- [ ] Check 3+ data sources (Levels.fyi, Glassdoor, Payscale, LinkedIn Salary)
- [ ] Confirm geographic tier and apply multiplier
- [ ] Calculate total comp (base + bonus + equity annualized + benefits value)
- [ ] Compare to internal peers at same level (±10% band)
- [ ] Document justification if above band midpoint
- [ ] Get sign-off from hiring manager + finance/HR

### 7. Retention Risk Scoring

| Factor | Weight | Score (1-5) |
|--------|--------|-------------|
| Below market rate (>10% under) | 25% | |
| Time since last raise (>18 months) | 20% | |
| Flight risk signals (LinkedIn active, disengaged) | 20% | |
| Critical role / hard to replace | 20% | |
| Tenure > 3 years with no promotion | 15% | |

**Score > 3.5** = immediate retention conversation needed
**Score 2.5-3.5** = include in next review cycle, prioritize
**Score < 2.5** = monitor quarterly

### 8. Commission & Sales Comp
For revenue roles, design OTE (On-Target Earnings):
- **Base:Variable split**: 50:50 (hunters), 60:40 (farmers), 70:30 (CS/AM)
- **Accelerators**: 1.5-3x rate above quota (motivates overperformance)
- **Decelerators**: 0.5x rate below 80% quota (protects company)
- **Clawback policy**: Define for churned deals within 90 days
- **SPIFs**: Short-term incentives for strategic pushes ($500-$5K per qualifying action)

## Key Metrics to Track
- **Offer acceptance rate**: Target >85% (below = comp is off-market)
- **Regrettable attrition**: Target <10% (above = retention issue)
- **Time to fill**: If increasing, may signal comp competitiveness problem
- **Cost per hire**: Include recruiter fees, signing bonuses, relocation
- **Revenue per employee**: Benchmark against industry ($200K-$400K SaaS, $150K-$250K services)

## Data Sources (2026)
- Levels.fyi — Best for tech roles, real verified data
- Glassdoor — Broad coverage, self-reported
- Payscale — Small business focus
- Radford (Aon) — Enterprise-grade, paid surveys
- Mercer — Global comp data, paid
- LinkedIn Salary Insights — Good for role-specific ranges
- BLS Occupational Employment Statistics — Government baseline

---

## More Frameworks

Need deeper operational frameworks for your industry?

**[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 each. Pre-built agent knowledge for Fintech, Healthcare, Legal, SaaS, Recruitment, and 5 more verticals.

**[AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Free tool. Find where you're losing money to manual work.

**[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)** — Configure your AI agent stack in minutes.

**Bundles:**
- Pick 3 packs — $97
- All 10 packs — $197
- Everything bundle — $247
