# Community Growth Engine 🏘️

Complete 12-phase system for building, growing, and monetizing online communities. From zero members to thriving ecosystem.

## What This Skill Does

Turns your AI agent into a community strategist that handles:

- **Strategy & Architecture** — Platform selection, channel design, role systems
- **Onboarding** — 24-hour activation flow that converts lurkers to participants
- **Content Programming** — Weekly calendar, engagement loops, conversation starters
- **Moderation** — Guidelines, decision matrix, moderator playbooks
- **Growth** — 12 tactics ranked by effort/impact, referral programs, content funnels
- **Monetization** — Free/premium/VIP tiers, pricing psychology, revenue models
- **Events** — AMA, workshops, challenges, co-working sessions
- **Member Lifecycle** — 5-stage journey with re-engagement playbooks
- **Health Metrics** — Dashboard with benchmarks by community size
- **Scaling** — Milestone-based playbooks from 0 to 10,000+ members

## Install

```bash
clawhub install afrexai-community-growth-engine
```

## Quick Start

Tell your agent:
- "Design my community" — Get a full strategy brief
- "Run community health check" — Score your community 0-100
- "Build growth strategy" — Prioritized tactics for your stage
- "Handle toxic member" — Scenario-specific playbook

## What's Inside

- 31KB SKILL.md with complete methodology
- Community brief YAML template
- Platform selection decision tree
- Channel architecture blueprints
- Onboarding flow with message templates
- Weekly content calendar system
- Moderation decision matrix with severity levels
- 12 growth tactics ranked by ROI
- Referral program design
- 3-tier monetization architecture
- Event execution templates
- Member lifecycle management
- Re-engagement sequence with copy
- Champion development program
- Health dashboard with benchmarks
- 100-point quality rubric
- 5 difficult situation playbooks
- Monthly + quarterly review templates
- 12 natural language commands

## ⚡ Level Up

Want the complete business context for your vertical?

**[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** ($47 each) — Deep industry knowledge that makes your AI agent an expert in SaaS, Healthcare, Legal, Fintech, Ecommerce, and more.

## 🔗 More Free Skills by AfrexAI

- [afrexai-growth-engine](https://clawhub.com/skills/afrexai-growth-engine) — Complete growth system (AARRR, experiments, loops)
- [afrexai-customer-success](https://clawhub.com/skills/afrexai-customer-success) — Retention & expansion revenue
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand building & GTM
- [afrexai-social-media-engine](https://clawhub.com/skills/afrexai-social-media-engine) — Multi-platform content system
- [afrexai-conversion-copywriter](https://clawhub.com/skills/afrexai-conversion-copywriter) — Copy that converts

Browse all skills: [AfrexAI on ClawHub](https://clawhub.com/publishers/afrexai-cto)

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI-powered business systems that actually work.* 🖤💛
