# Cleaning Business Operations

Commercial and residential cleaning business operations agent. Covers pricing, bidding, staffing, supply costs, insurance, OSHA compliance, quality control, and growth from solo operator to multi-crew company.

## When to Use
- Starting or scaling a cleaning business (residential, commercial, janitorial)
- Bidding on commercial contracts
- Setting pricing for residential services
- Managing crews, supplies, and scheduling
- Understanding insurance, bonding, and compliance requirements

## Pricing Reference

### Residential Cleaning (2026 US Market)
| Service | Per Visit | Per Sq Ft |
|---------|-----------|-----------|
| Standard clean (2-3 bed) | $120-$200 | $0.08-$0.12 |
| Deep clean | $200-$400 | $0.15-$0.25 |
| Move-in/move-out | $250-$500 | $0.18-$0.30 |
| Post-construction | $350-$800 | $0.25-$0.50 |
| Window cleaning (interior) | $5-$10/window | — |
| Carpet cleaning | $25-$75/room | $0.20-$0.40 |

### Commercial/Janitorial (Monthly Contracts)
| Facility Type | Per Sq Ft/Month | Frequency |
|--------------|-----------------|-----------|
| Small office (<5K sq ft) | $0.05-$0.10 | 3-5x/week |
| Medical/dental | $0.12-$0.20 | Daily |
| Retail | $0.04-$0.08 | Daily |
| Warehouse/industrial | $0.03-$0.06 | 2-3x/week |
| School/daycare | $0.08-$0.15 | Daily |
| Restaurant | $0.15-$0.25 | Daily |

### Bidding Formula (Commercial)
```
Monthly Price = (Cleanable Sq Ft × Rate) + (Restrooms × $75-$150) + (Specialty Areas × Premium)
Production Rate Target: 2,500-3,500 sq ft/hour (general office)
```

## Staffing & Labor

### Pay Ranges (2026)
| Role | Hourly | Annual |
|------|--------|--------|
| Cleaner (entry) | $14-$18 | $29K-$37K |
| Experienced cleaner | $16-$22 | $33K-$46K |
| Team lead | $18-$25 | $37K-$52K |
| Operations manager | $22-$30 | $46K-$62K |
| Quality inspector | $18-$24 | $37K-$50K |

### Crew Productivity Benchmarks
- Solo operator: 3-5 residential jobs/day or 1 commercial site
- 2-person crew: 5-8 residential jobs/day
- Target billable hours: 6-7 per 8-hour shift
- Drive time between jobs: budget 15-30 min
- Turnover rate industry avg: 200-400% annually — retention is your #1 cost lever

## Supply Costs

### Per-Job Supply Cost Targets
| Job Type | Supply Budget | % of Revenue |
|----------|--------------|--------------|
| Standard residential | $3-$8 | 3-5% |
| Deep clean | $8-$15 | 4-6% |
| Commercial (per visit) | $5-$20 | 5-8% |

### Key Supplies (Monthly, Per Crew)
- All-purpose cleaner: $15-$25
- Disinfectant: $20-$35
- Glass cleaner: $10-$15
- Microfiber cloths (reusable): $30-$50/quarter
- Vacuum (commercial): $300-$800 (replace annually)
- Mop system: $50-$150
- Trash bags: $25-$40
- Paper products/restroom supplies (commercial): client-supplied or $0.02-$0.05/sq ft markup

## Insurance & Bonding

| Coverage | Annual Cost | Required? |
|----------|------------|-----------|
| General liability ($1M/$2M) | $400-$1,200 | Yes — non-negotiable |
| Workers' comp | $2-$5 per $100 payroll | Yes (with employees) |
| Surety bond ($10K-$50K) | $100-$500 | Commercial contracts require it |
| Commercial auto | $1,200-$3,000/vehicle | Yes |
| Umbrella ($1M) | $300-$600 | Recommended for commercial |
| Employee dishonesty bond | $150-$400 | Recommended |

**Total insurance cost target: 5-8% of revenue**

## OSHA & Compliance

### Chemical Safety (OSHA 29 CFR 1910.1200)
- Safety Data Sheets (SDS) for every chemical — accessible on-site
- Hazard Communication training before first day of work
- PPE provided: gloves, eye protection for chemicals
- No mixing chemicals (especially bleach + ammonia = toxic gas)
- Bloodborne pathogen training for medical facility cleaning

### Common OSHA Violations in Cleaning
| Violation | Penalty |
|-----------|---------|
| No SDS on-site | $1,000-$15,000 |
| Missing hazcom training | $1,000-$15,000 |
| No PPE provided | $1,000-$15,000 |
| Wet floor without signage | $1,000-$7,000 |
| Improper ladder use | $1,000-$15,000 |
| Willful violation | Up to $156,259 |

### Green Cleaning Certifications
- ISSA CIMS (Cleaning Industry Management Standard) — gold standard for commercial
- Green Seal GS-37 (cleaning products) / GS-42 (services)
- LEED-compatible cleaning programs increase commercial contract win rate by 15-25%

## Quality Control

### Inspection Checklist (Score 1-5 per area)
1. Floors — vacuumed/mopped, edges, corners
2. Surfaces — dusted, wiped, streak-free
3. Restrooms — sanitized, restocked, mirrors, fixtures
4. Trash — emptied, liners replaced, area clean
5. Windows/glass — fingerprints, smudges, sills
6. Kitchen/break room — appliances, sink, counters
7. Overall appearance — clutter, odor, presentation

**Target: 4.5+ average. Below 4.0 = re-clean required.**

### Client Retention Metrics
- Satisfaction survey after first 3 cleans, then quarterly
- 90-day retention target: 85%+
- Annual retention target: 70%+ (residential), 85%+ (commercial)
- Complaint resolution: respond within 2 hours, re-clean within 24 hours

## Growth Playbook

### Stage 1: Solo Operator ($0-$80K/year)
- 15-20 recurring residential clients = $4K-$6K/month
- Zero employees, minimal overhead
- Focus: reviews, referrals, Google Business Profile
- Reinvest 20% into marketing

### Stage 2: First Crew ($80K-$250K/year)
- Hire 2-3 cleaners, train to your standard
- Add 1-2 commercial contracts for stable base revenue
- Systems: scheduling software, checklists, supply tracking
- You stop cleaning, start managing and selling

### Stage 3: Multi-Crew ($250K-$1M/year)
- 3-5 crews, dedicated office manager
- Mix: 60% commercial / 40% residential (commercial = predictable)
- Fleet: branded vehicles (rolling billboards)
- Bid on larger contracts: schools, medical, property management companies

### Stage 4: Scale ($1M+/year)
- Operations manager runs day-to-day
- Focus: sales, key accounts, strategic partnerships
- Consider franchise model or territory licensing
- Target: 15-25% net profit margin at scale

## KPIs to Track
1. Revenue per labor hour (target: $45-$65)
2. Client retention rate (target: 80%+)
3. Complaint rate (target: <2% of jobs)
4. Employee turnover (target: <100% annually — half the industry avg is a win)
5. Supply cost as % of revenue (target: <6%)
6. Close rate on bids (target: 30-40% residential, 20-30% commercial)
7. Average job value (track monthly, push upward)
8. Drive time as % of work time (target: <20%)
9. Rebooking rate — residential (target: 70%+ rebook after first clean)
10. Revenue per client per year (target: $2,400+ residential, $12,000+ commercial)

## Common Mistakes
1. Pricing too low to "get clients" — race to bottom kills margins
2. No written contracts for commercial — verbal agreements = disputes
3. Skipping insurance — one slip-and-fall lawsuit ends the business
4. Not tracking supply costs — death by a thousand small purchases
5. Hiring without background checks — you're in people's homes
6. No quality inspection system — problems compound silently
7. Over-relying on residential — commercial contracts are the stability backbone
8. Ignoring employee retention — constant retraining is the hidden cost killer

---

## More Industry-Specific Operations Resources

Get the full AfrexAI context pack library for your AI agents:

- **Industry Context Packs** ($47 each): https://afrexai-cto.github.io/context-packs/
- **AI Revenue Leak Calculator** (free): https://afrexai-cto.github.io/ai-revenue-calculator/
- **Agent Setup Wizard** (free): https://afrexai-cto.github.io/agent-setup/
- **Pick 3 Bundle** ($97): Any 3 industry packs
- **Full Library** ($197): All 10 industry packs
- **Everything Bundle** ($247): All packs + playbook + priority support

Built by AfrexAI — we build AI agents that actually run businesses.
